<div class="project-home">
    <?= $this->load->view('/partials/aside') ?>
    <main class="build-modules">
        <?= $this->load->view('/partials/search') ?>
        <div class="build-welcome">
            <div>
                <h1>Welcome to CFEngine Build</h1>
                <div class="build-welcome_subtitle">
                    Here you can add and configure modules easily to your projects and help you to automate the process
                    with less effort.
                </div>
                <div class="build-welcome_button">
                    <a class="btn btn-primary" href="/build/modules">
                        Find modules <i class="bi bi-chevron-right"></i>
                    </a>
                </div>
            </div>
            <div class="build-welcome_illustration">
            </div>
        </div>
        <div ng-show="showQuickstart" class="build-quickstart">
            <div class="build-quickstart_help">You have not yet finished the setup. Follow the guide to start your
                project today!
            </div>
            <div class="build-quickstart_card">
                <div class="build-quickstart_card-top">
                    <h2>Quickstart guide</h2> <a ng-click="showQuickstart=false" class="btn btn-info"><i class="bi bi-x"></i> Dismiss</a>
                </div>
                <div class="build-quickstart_card-body">
                    <span>Get started using CFEngine build to manage, set up and deploy your first set of modules in Mission Portal.</span>
                    <ol>
                        <li>
                            <div>Add masterfiles module</div>
                            <span><a href="/build/modules/masterfiles">masterfiles</a> is the default policy that is included in the CFEngine packages,
                                so it is already running on your hub.
                            </span>
                        </li>
                        <li>
                            <div>Add another module</div>
                            <span>
                                Explore and add modules you would like.
                                We recommend adding <a href="/build/modules/inventory-sudoers">inventory-sudoers</a> or <a
                                        href="/build/modules/compliance-report-os-is-vendor-supported/">supported-operating-system</a> to start.
                            </span>
                        </li>
                        <li>
                            <div>Deploy policy set</div>
                            <span>Click Deploy button on the top of the page to deploy your changes.</span>
                        </li>
                        <li>
                            <div>Set up git repo sync</div>
                            <span>Set up the git repo sync to update the working files from Mission Portal.</span>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div ng-repeat="(category, _) in moduleCategories">
            <div class="modules-title">
                <h2>Modules for {{ category }}</h2>
            </div>
            <div class="flex flex-wrap">
                <div ng-repeat="module in moduleCategories[category]" class="modules-item">
                    <div class="flex flex--align_center">
                        <div class="modules-item_name flex-grow">
                            <div class="flex flex--align_center">
                                <div class="modules-item_avatar">
                                    <img width="32" height="32"
                                         src="{{ module.author.image }}" />
                                </div>
                                <div>
                                    <a href="/build/modules/{{ module.name }}/"
                                       class="modules-item_title">{{ module.name }}</a>
                                    <div class="modules-item_author">by {{ module.author.name }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div ng-bind-html="module.description" class="modules-item_description"></div>
                    <div class="modules-item_version">version: {{ module.version }}</div>
                </div>
            </div>
        </div>
    </main>
</div>
