// Librarian

var path        = require('path')
var fs          = require('fs')
var temp        = require('temp')

var Joose       = require('../../../joose-all')

var File        = require('./File')
var Template    = require('./Template')

// will create a ModuleResolver var
eval(fs.readFileSync(require.resolve('../util/module_resolver.js'), 'utf8'))


module.exports = Joose.Class({
    
    does    : Joose.Role(ModuleResolver),
    
    has     : {
        coreModules     : {
            init        : {
                'fs'    : true,
                'path'  : true,
                'event' : true
            }
        },
        
        root            : { required : true },
        
        processed       : Joose.I.Object,
        
        files           : Joose.I.Object,
        
        includeJooseCompat  : false,
        
        tempRoot        : {
            is          : 'rwc',
            lazy : function () { return temp.mkdirSync() }
        },
        
        template        : {
            is          : 'rwc',
            lazy        : function () { return new Template( fs.readFileSync(require.resolve('../util/module_wrapper.js'), 'utf8') ) }
        }
    },
    
    
    override : {
        
        resolve : function (require, baseDir, dependencies) {
            if (baseDir instanceof File) baseDir = path.dirname(baseDir.name)
            
            var resolvedTo = this.SUPER(require, baseDir, dependencies || {})
            
            if (!resolvedTo) throw new Error("Failed to resolve [" + require + "] in the directory [" + path.join(this.root, baseDir) + "]")
            
            return resolvedTo
        }
    },
    
    
    methods : {
        
        addAdditionalDependency : function (dependencies, fileName) {
            dependencies[ fileName ] = this.getFile(fileName)
        },
        
        
        initialize : function () {
            this.root       = path.resolve(this.root)
        },
        
        
        getFileAsJSON : function (fileName) {
            return JSON.parse(this.getContentOf(fileName))
        },
        
        
        getContentOf : function (fileName) {
            if (fileName instanceof File) fileName = fileName.name
            
            return fs.readFileSync(path.join(this.root, fileName), 'utf8')
        },
        
        
        getCoreModule : function (coreModule) {
            throw new Error('not supported yet')
        },
        
        
        fileExists : function (fileName) {
            try {
                var stat    = fs.statSync(path.join(this.root, fileName))
                
                return stat.isFile()
                
            } catch (e) {
                return false
            }
        },
        
        
        getFile : function (fileName) {
            var files   = this.files
            
            if (files[ fileName ]) return files[ fileName ]
        
            return files[ fileName ] = new File({
                name        : fileName,
                librarian   : this
            })
        },
        
        
        wrap : function (file) {
            
            return this.template().render({
                content     : this.getContentOf(file),
                
                includeJooseCompat  : this.includeJooseCompat,   
                
                fileName    : file.name,
                dirName     : path.dirname(file.name)
            })
        },
        
        
        writeBundleTo : function (stream, requires, files) {
            var me              = this
            var allDeps         = {}
            
            var requirements    = Joose.A.map(requires, function (require) {
                return me.getFile(me.resolve(require, '.', allDeps))
            })
            
            var scripts         = Joose.A.map(files, function (file) {
                return me.getFile(path.relative(me.root, path.resolve(file)))
            })
            
            Joose.A.each(scripts.concat(requirements), function (file) {
                
                allDeps[ file.name ] = file
                
                Joose.O.each(file.getInDepthDependencies(), function (file, name) {
                    if (allDeps[ name ] && allDeps[ name ] != file) throw new Error('Inconsistency')
                    
                    allDeps[ name ] = file
                })
            })
            
            Joose.O.each(allDeps, function (file) {
                stream.write(me.wrap(file) + ';\n')
            })
            
            Joose.A.each(scripts, function (file) {
                stream.write('require("' + file.name + '");\n')
            })
        },
        
        
        process : function (fileName, callback, errback) {
            if (!/\.js$/.test(fileName)) 
                callback(fileName, this.root)
            else {
                var tempRoot        = this.tempRoot()
                var file            = this.getFile(fileName)
                
                if (this.processed[ file.name ])
                    callback(fileName, tempRoot)
                else {
                    var tempFile    = path.join(tempRoot, fileName)
                    
                    fs.mkdirSync(path.dirname(tempFile), 0777)
                    
                    var stream      = fs.createWriteStream(tempFile, { encoding : 'utf8'})

                    stream.on('close', function () {
                        
                        callback(fileName, tempRoot)
                    })
                    stream.on('error', errback)
                    
                    try {
                        this.writeBundleTo(stream, [], [ fileName ])
                        
                        this.processed[ file.name ] = true
                        
                        stream.end()
                    } catch (e) {
                        errback(e)
                        
                        return
                    }
                }
            }
        }
    }
})