// alter.js
// MIT licensed, see LICENSE file
// Copyright (c) 2013 Olov Lassus <olov.lassus@gmail.com>

var assert = require("assert");
var stableSort = require("stable");

// fragments is a list of {start: index, end: index, str: string to replace with}
function alter(str, fragments) {
    "use strict";

    var isArray = Array.isArray || function(v) {
        return Object.prototype.toString.call(v) === "[object Array]";
    };;

    assert(typeof str === "string");
    assert(isArray(fragments));

    // stableSort isn't in-place so no need to copy array first
    var sortedFragments = stableSort(fragments, function(a, b) {
        return a.start - b.start;
    });

    var outs = [];

    var pos = 0;
    for (var i = 0; i < sortedFragments.length; i++) {
        var frag = sortedFragments[i];

        assert(pos <= frag.start);
        assert(frag.start <= frag.end);
        outs.push(str.slice(pos, frag.start));
        outs.push(frag.str);
        pos = frag.end;
    }
    if (pos < str.length) {
        outs.push(str.slice(pos));
    }

    return outs.join("");
}

if (typeof module !== "undefined" && typeof module.exports !== "undefined") {
    module.exports = alter;
}
