<?php

class CfEvent
{

    /**
     * @var PDO
     */
    private $dbConnection;

    /**
     * CfEvent constructor.
     */
    public function __construct()
    {
        $this->dbConnection = CfdbPdo::getInstance()->getConnection();
    }

    public function getEventList()
    {
        return $this->dbConnection->query('SELECT * FROM events')->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getEventById($id)
    {
        $stmt = $this->dbConnection->prepare('SELECT * FROM events WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function deleteEventById($id)
    {
        return $this->dbConnection->prepare('DELETE FROM events WHERE id = ? ')->execute([$id]);
    }

    public function deleteBatch($ids)
    {
        $placeHolders = implode(',', array_fill(0, count($ids), '?'));
        return $this->dbConnection->prepare('DELETE FROM events WHERE id IN (' . $placeHolders . ')')->execute($ids);
    }
}