/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global document, reports, common, $httpProvider, angular, environmentSelectionDirective, $timeout, _*/

'use strict';

/* Directives */


reports.config(function ($httpProvider, $provide) {
    //
    // On a Success or Error request, broadcast that we want the spinner to stop
    //
    var spinnerFunction, hideSpinner, interceptor;

    spinnerFunction = function (data, headersGetter) {
        const headers = headersGetter();

        if (headers['hide-spinner'] !== true) {
            common.globalSpinner.show();
        }
        return data;
    };

    $provide.factory('httpResponseInterceptors', ['$rootScope', '$q', function ($rootScope, $q) {
        return {
            response: function (response) {
                common.globalSpinner.hide();
                return response || $q.when(response);
            },
            responseError: function (rejection) {
                common.globalSpinner.hide();
                return $q.reject(rejection);
            }
        }
    }]);

    $httpProvider.defaults.transformRequest.push(spinnerFunction);
    $httpProvider.interceptors.push('httpResponseInterceptors');
});

/*
 Addselect all checkbox to the field list. Watch for changes
 Set indeterminate property to checkbox if not all checkboxes checked
*/
reports.directive('selectAllCheckbox', function () {
    return {
        replace: true,
        restrict: 'E',
        scope: {
            checkboxes: '=',
            tableid: '='
        },
        template: '<label><input type="checkbox" class="selectAll_SE" ng-model="master" ng-change="masterChange()"> Select all</label>',
        controller: function ($scope, $element, $attrs) {

            $scope.masterChange = function () {
                if ($scope.master) {
                    angular.forEach($scope.checkboxes, function (cb, index) {
                        if (!cb.isSelected) {
                            cb.isSelected = true;
                            $scope.$parent.saveField('fields', $scope.tableid, index);
                        }
                    });
                } else {
                    angular.forEach($scope.checkboxes, function (cb, index){
                        $scope.$parent.splice(cb, 'fields');
                        cb.isSelected = false;
                    });
                }
            };
            $scope.$watch('checkboxes', function () {
                var allSet = true, allClear = true;
                angular.forEach($scope.checkboxes, function (cb, index){
                    if (cb.isSelected) {
                        allClear = false;
                    } else {
                        allSet = false;
                    }
                });
                if (allSet) {
                    $scope.master = true;
                    $element.find('input[type=checkbox]').prop('indeterminate', false);
                } else if (allClear) {
                    $scope.master = false;
                    $element.find('input[type=checkbox]').prop('indeterminate', false);
                } else {
                    $scope.master = false;
                    $element.find('input[type=checkbox]').prop('indeterminate', true);
                }
            }, true);
        }
    };
});
/**
 * Directive to display table list in  3 colunms
 *
 *
 * tabledata      - object with all tables info (DCA)
 * selectedtables - equal to the SelectedTabled from the parent scope
 * parentfunc     - function to react on scope change
 *
 * usage: show table list on editWizard and rolelist on searchModal
 */
reports.directive('tableList', [function () {
    return {
        restrict: 'A',
        template: '<div ng-repeat="(i,tables) in viewData">' +
                        '<ul class="group-items float-left" style="margin-bottom:0">' +
                            '<li ng-repeat="(tableId, table) in tables">' +
                                '<div class="checkbox">' +
                                    '<label for="table_{{table[1].TableID}}">' +
                                    '<input ' +
                                        'type="checkbox" ' +
                                        'ng-model="selectedtables[table[1].TableID]" ' +
                                        'ng-click="selectTable({tableID: table[1].TableID, event: $event})" ' +
                                        'name="group" ' +
                                        'id="table_{{table[1].TableID}}" />' +
                                    '{{table[1].label}}' +
                                    '</label>' +
                                '</div>' +
                             '</li>' +
                         '</ul>' +
                    '</div>',
        link: function (scope, element, attrs) {
            var tablesTMP = [], length, totalP, partition, i; // how many columns

            // prepare datat and sort
            angular.forEach(scope.tabledata, function (table, tableId) {
                var data = {};
                data['label']   = (table.label !== undefined ? table.label : table); // if no label - use id as label
                data['TableID'] = (table.label !== undefined ? tableId : table);

                if (table.label !== undefined) {
                    tablesTMP.push([table.label, data]);
                } else {
                    tablesTMP.push([table, data]);
                }
            });

            tablesTMP.sort();


            // small adjustment, show different collumn count depends on items count
            if (tablesTMP.length <= 3) {
                partition = 1;
            } else if (tablesTMP.length <= 6) {
                partition = 2;
            } else {
                partition = 3;
            }

            length = tablesTMP.length;
            totalP = Math.ceil(length / partition);

            scope.viewData = [];

            for (i = 0; i < totalP; i++) {
                scope.viewData[i] = tablesTMP.slice(i * partition, (i * partition) + partition);
            }

        },
        scope: {
            tabledata       : '=',
            selectedtables  : '=',
            selectTable     : '&'
        }
    };
}]);


/**
 * Simple directive to display table rows.
 * Removes the need for ng-repeat to just display data.
 */
reports.directive('trRows', ['$compile', function ($compile) {
    return {
        restrict: 'EA',
        template: '',
        replace: true,
        link: function (scope, element, attrs) {
            scope.$watch('rowdata', function() {
                var html = '';
                angular.forEach(scope.rowdata, function(tr, trkey) {
                    html += '<tr>';
                    angular.forEach(tr, function(td, tdkey){

                        if (td === null ) {
                            td = '<i class="muted">(Not reported)</i>'
                        }

                        if (td === '') {
                            td = '<i class="muted">(Empty)</i>'
                        }

                        // match a valid url (https://ihateregex.io/expr/url/) and replace with a link
                        const urlReg = new RegExp(
                            /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()!@:%_\+.~#?&\/\/=]*)$/i
                        );
                        if (urlReg.test(td)) {
                            td = `<a target="_blank" href="${td}">${td}</a>`;
                        }

                        let icon = '';
                        if (scope.highlight !== undefined && Object.keys(scope.highlight).length > 0) {
                            Object.keys(scope.highlight).forEach(item => {
                                if (td === item) {
                                    switch (scope.highlight[item]) {
                                        case 'green':
                                            icon = '<i class="green margin-right-small icon-ok-sign"></i>';
                                            break;
                                        case 'red':
                                            icon = '<i class="red margin-right-small icon-warning-sign"></i>';
                                            break;
                                    }
                                }
                            });
                        }

                        if (scope.tablehead != undefined && scope.tablehead[tdkey]) {
                            html += `<td class="${scope.tablehead[tdkey].type || ''}">${icon} ${td}</td>`;
                        } else {
                            html += '<td>'+ icon + td +'</td>';
                        }

                    });
                    html += '</tr>';
                });
                // html may contain directives, should be compiled
                let linkFn = $compile(html);
                let content = linkFn(scope);
                element.html(content);
            });
        },
        scope: {
            rowdata: '=',
            tablehead: '=',
            highlight: '='
        }
    };
}]);


reports.directive('notifications', ['notificationService', '$timeout', function (notificationService, $timeout) {
    return {
        restrict: 'A',

        template: '<div id="notification_block" ng-repeat="(type, notification) in notificationsList">'+
                    '<div ng-if="type==\'error\'"   class="alert alert-error">{{notification.text}}</div>' +
                    '<div ng-if="type==\'success\'" class="alert alert-info">{{notification.text}}</div>' +
                    '<div ng-if="type==\'warning\'" class="alert alert-warning">{{notification.text}}</div>' +
                '</div>',

        link: function($scope, $elm, $attrs) {
            $scope.$on('setNotification', function () {
                $scope.notificationsList = notificationService.getNotifications();

                if ($scope.modalOpen === undefined || $scope.modalOpen.status === false) {
                    window.scrollTo(null, (angular.element("#notification_block_wrapper").position().top - 40));
                    if ($(".alert-info")) {
                        // make sure it displays again for multiple actions after initial fadeTo
                       $(".alert-info").fadeTo(0,1);
                    }
                    $timeout(function() {
                        if ($(".alert-info")) {
                            //check for alert-info, fade and hide if exists
                            $(".alert-info").fadeTo(500, 0).slideUp(500);
                        }
                    }, 5000);
                }
            });

            $scope.$on('resetNotificationMessage', function () {
                $scope.notificationsList = {};
            });


            $scope.$on('modalOpen', function () {
                $scope.modalOpen = {'status':true};
            });


            $scope.$on('modalClose', function () {
                $scope.modalOpen = {'status':false};
            });
        }
    };
}]);

reports.directive('focusMe', function ($timeout) {
    return {
        link: function (scope, element) {
            $timeout(function () {
                element[0].focus();
            });
        }
    };
});

reports.directive( 'ngAmpereDebounce', [ function() {
    var DEFAULTS = { timeout : 1000 }
    ;

    return {
        restrict : 'A',
        link: function( scope, element, attrs) {
            // normalize directive options
            var options = scope.$eval( attrs.ngAmpereDebounce) || $.extend( {}, DEFAULTS);
            if( options==='leading') {
                options = $.extend( { leading : true}, DEFAULTS);
            } else {
                options.leading = !!options.leading;	// make it a real boolean
            }

            var map = $._data( element[0], 'events'),
                events = $.each( Object.keys( map), function( index, eventName) {
                    // ensure only real events are handled
                    if( eventName.charAt( 0)!='$') {
                        // install debounce mechanism
                        var debounced = $.debounce( options.timeout, options.leading, function( event) {
                            // iterate over all event handlers registered before ourself
                            // (remember : we moved ourself at first position while installing)
                            for( var i=$.inArray( debounce_handlerobj, map[eventName])+1; i<map[eventName].length; i++) {
                                var handlerobj = map[eventName][i];

                                // call original event handler
                                handlerobj.handler.apply( this, arguments);
                                // emulate regular event dispatching by
                                // aborting further propagation when event
                                // has state immediatePropagationStopped
                                if( event.isImmediatePropagationStopped()) {
                                    break;
                                }
                            }
                        });

                        element.on( eventName, function( event) {
                            debounced.apply( this, arguments);
                            // tell jquery to suppress further propagation of this event
                            event.stopImmediatePropagation();
                        });

                        // move our debounce handler at first position
                        // to be called before any other
                        var debounce_handlerobj = map.input.pop();
                        map.input.unshift( debounce_handlerobj);
                    }
                })
            ;
        }
    };
}]);

reports.directive('ngFocus', ['$parse', function($parse) {
  return function(scope, element, attr) {
    var fn = $parse(attr['ngFocus']);
    element.bind('focus', function(event) {
      scope.$apply(function() {
        fn(scope, {$event:event});
      });
    });
  }
}]);

reports.directive('ngBlur', ['$parse', function($parse) {
  return function(scope, element, attr) {
    var fn = $parse(attr['ngBlur']);
    element.bind('blur', function(event) {
      scope.$apply(function() {
        fn(scope, {$event:event});
      });
    });
  }
}]);

reports.directive('multiselectDropdown', [function() {
    return function(scope, element, attributes) {

        // Below setup the dropdown:

        element.multiselect({
            buttonClass : 'btn btn-large margin-top',
            buttonContainer : '<div class="btn-group" />',
            maxHeight : 500,
            enableFiltering : false,
            enableCaseInsensitiveFiltering: false,
            buttonText : function(options) {
                return element.data()['placeholder'];
            },
            // Replicate the native functionality on the elements so
            // that angular can handle the changes for us.
            onChange: function (optionElement, checked) {
                optionElement.removeAttr('selected');
                if (checked) {
                    optionElement.prop('selected', 'selected');
                }
                element.change();
            }

        }).hide();
        // Watch for any changes to the length of our select element
        scope.$watch(function () {
            return element[0].length;
        }, function () {
            element.multiselect('rebuild');
        });

        // Watch for any changes from outside the directive and refresh
        scope.$watch(attributes.ngModel, function () {
            element.multiselect('refresh');
        });

        // Below maybe some additional setup
    }
}]);

reports.directive('chozen', function(){
    var linker = function(scope,element,attr) {
        if (attr.search=="false") {
            element.chosen({disable_search_threshold:9999});
        } else {
            element.chosen({disable_search_threshold:5});
        }
        scope.$watchCollection(attr.watch, function(){
            element.trigger('chosen:updated');
        })
        scope.$watch(attr.ngModel, function(){
            element.trigger('chosen:updated');
        })
        scope.$watch(attr.disable,function(newValue){
            var val = newValue || false;
            element.prop('disabled', val);
            element.trigger('chosen:updated');
        })
    }
    return {
        restrict:'A',
        link: linker
    }
});

reports.directive('hiddenCsv', function(){
    var linker = function(scope, element, attr) {
        scope.$watch("csvArray", function(newValue) {
            if (!angular.equals(undefined, newValue)) {
                element.click();
            }
        });
    }
    return {
        link: linker
    }
});

reports.directive('columnDropdown', ['$timeout',function($timeout){
    var linker = function(scope, element, attr) {

        scope.columnIndex = parseInt(attr.columnIndex);
        // add fade out delay on hover out
        element.find('li.dropdown-submenu').hover(function() {
          $(this).find('.dropdown-menu').stop(true, true).fadeIn(200);
        }, function() {
          $(this).find('.dropdown-menu').stop(true, true).delay(200).fadeOut();
        });

        var table = angular.element('.horizontal-scroll');

        var handler = function() {
            var header = angular.element('#header'+scope.$index);
            var dropdown =  element.find('#dropdown-container');
            updatePosition(dropdown, header);
        };

        var handlerLoop = function() {
            // loop through all dropdown elements in table and change css
            // only used when width is altered by a scrollbar appearing onscreen if dropdown is long
            if (scope.$last) {
                for (var i=0;i<=scope.$index;i++) {
                    var header = angular.element('#header'+i);
                    var dropdown = angular.element('#dropdown'+i).find('#dropdown-container');
                    updatePosition(dropdown, header);
                }
            }
        };

        function updatePosition(dropdown, header) {
             if (header.offset()&&table.height()>0) {
                var left = header.offset().left-161;
                var top = 0-table.height();
                var width = header.outerWidth(false);

                dropdown.css('left',left);
                dropdown.css('top',top);
                dropdown.css('display','block');
                dropdown.css('width',width);

                if (left>table.outerWidth(false)-header.outerWidth(false)+20||left<22-header.outerWidth(false)) {
                    // hides icon if scrolling table moves it outwidth bounds of container
                    dropdown.css('display','none');
                }
            }
        }

        var link = element.find('a.dropdown-toggle');
        link.on('click', scope.$apply.bind(scope, handler));

        var submenu = angular.element('li.dropdown-submenu');
        submenu.on('mouseenter', scope.$apply.bind(scope, handlerLoop));
        submenu.on('mouseleave', scope.$apply.bind(scope, handlerLoop));

        table.on('scroll', scope.$apply.bind(scope, handler));
        $(window).on('resize', scope.$apply.bind(scope, handler));

        scope.$watch('result', function() {
            $timeout(function() {
                handler();
            });
        });

        scope.$watch('selectedCols', function() {
            $timeout(function() {
                handler();
            });
        }, true);

        //added timeouts to stop element from visibly jumping y-position on screen
        $timeout(function() {
            handler();
        });
    }
    return {
        restrict: 'A',
        templateUrl: MP_SITE_URL + '/advancedreports/partials/directive_columnDropdown',
        link: linker
    }
}]);

reports.directive('sqlReady', function() {
    return function($scope, element, attrs) {
        var sql = element[0].value;
        $scope.$emit('healthReportSqlChanged', {sql: sql, type: attrs.type,});
    };

});


reports.directive('chosenFilesAutoComplete', ['fimService', '$rootScope', function (fimService, $rootScope) {
    let linker = function ($scope, element, attr) {
        element.chosen({width: "350px"});
        let searchInput = document.querySelector(".hostFilter .chosen-search input");
        let placeholder = document.createAttribute("placeholder");
        placeholder.value = attr.placeholder;
        searchInput.setAttributeNode(placeholder);
        let allFilesOption = {name: "All files", id: "%"};

        $scope.searchCompleteSelected = allFilesOption;
        $scope.searchComplete = [allFilesOption];

        let buildFileTree = function (search_param = '') {
            fimService.searchFiles(search_param).then(
                function (result) {
                    if (result.data !== undefined && result.data.length > 0) {
                        $scope.clearSearchComplete();
                        result.data.forEach(function (item) {
                            $scope.searchComplete.unshift({
                                name: item,
                                id: item
                            });
                        })

                    }
                },
                function (result) {
                    notify.error('Unexpected error while getting file list.');
                    console.error(result.data);
                })
        };

        //init file tree
        buildFileTree();

        $scope.selectHost = function (selectedValue) {
            $rootScope.$broadcast('fileSelected', selectedValue);
        };

        $scope.$on('fileFilterCleared', function () {
            $scope.searchCompleteSelected = allFilesOption;
        })

        $scope.clearSearchComplete = function () {
            $scope.searchComplete = [allFilesOption];
        };

        $scope.$watchCollection(attr.watch, function () {
            let search_param = searchInput.value.toString();
            element.trigger('chosen:updated');
            searchInput.value = search_param;
        })

        $scope.$watch(attr.ngModel, function () {
            let search_param = searchInput.value.toString();
            element.trigger('chosen:updated')
            searchInput.value = search_param;
        })

        searchInput.onkeyup = function () {
            let search_param = searchInput.value.toString();
            if (search_param.length > 2) {
                // replace \ with \\ to perform correct search in postgresql
                // otherwise backslash will be used to escape characters
                buildFileTree(search_param.replace(/\\/g, '\\\\'));
            }
        };
    }
    return {
        restrict: 'A',
        link: linker
    }
}]);

reports.directive('diffToHtml', ['$rootScope', '$modal', function ($rootScope, $modal) {
    let linker = function ($scope, element, attr) {
        let self = this;
        $scope.modalWindow = $modal;

        let diff = $(element).closest('div').find('textarea').text();
        if (diff == undefined || diff.length == 0) {
            return;
        }

        $scope.showDiff = function () {
            this.modalInstance = $scope.modalWindow.open({
                templateUrl: 'showDiffModal.html',
                backdrop: 'static',
                keyboard: true,
                windowClass: 'include',
                controller: function ($scope, $modalInstance, fimService) {
                    $scope.fileName = $(element).closest('tr').find('td:first-child').text();
                    $scope.exportTitle = "'" + $scope.fileName + "diff'";
                    $scope.now = common.time.format(new Date())
                    fimService.convertDiffToHtml(diff).then(function (data) {
                        $scope.diff = data.data.html;
                        $scope.csvArray = data.data.array;
                    })
                    $scope.close = function () {
                        $modalInstance.close('cancel');
                    };

                },
                resolve: {
                    $parent: function () {
                        return self;
                    }
                }
            });

        };
        element.bind('click', $scope.showDiff);
    }
    return {
        restrict: 'A',
        link: linker
    }
}]);

reports.directive('ruleDetails', ['$filter', function ($filter) {
    return {
        replace: true,
        restrict: 'A',
        scope: {
            rule: '='
        },
        template: `
        <ul>
            <li ng-repeat="(key, value) in details">
                <span ng-if="value"><h5 class="inline" ng-if="key">{{key}}: </h5>{{value}}</span>
            </li>
        </ul>`,
        controller: function ($scope) {
            $scope.details = {};
            let condition;
            switch ($scope.rule.type) {
                case 'policy':
                    condition = $scope.rule.policyConditions;
                    $scope.details = {
                        "": "Policy",
                        "Promise outcome": condition.promiseoutcome
                    };

                    if (condition.filterBy != undefined && condition.filterItemName != undefined) {
                        $scope.details[condition.filterBy.capitalizeFirstLetter()] = condition.filterItemName;
                    }
                    break;
                case 'inventory':
                    $scope.details[''] = 'Inventory';
                    for (const filter of $scope.rule.inventoryConditions.filters) {
                        const condition = $filter('FilterConditionLabel')(filter.condition, filter);
                        const value = filter.type === 'string' ? `'${filter.value}'` : filter.value;
                        $scope.details[filter.label] = `${condition} ${value}`;
                    }
                    break;
                case 'softwareupdate':
                    $scope.details[''] = 'Software updates';
                    condition = $scope.rule.softwareUpdateConditions;
                    $scope.details['Package name'] = condition != null && condition.patchname != '' ? condition.patchname : 'All';
                    $scope.details['Architecture'] = condition != null && condition.patcharchitecture != '' ? condition.patcharchitecture : 'All';
                    break;
                case 'custom':
                    $scope.details[''] = 'Custom SQL';
                    $scope.details['SQL'] = $scope.rule.customConditions.sql;
                    break;
                case 'fileChanged':
                    $scope.details[''] = 'File changed';
                    condition = $scope.rule.fileChangedConditions;
                    $scope.details['File name'] = `${condition.condition} '${condition.fileName}'`;
                    $scope.details['Changed within the time period'] = `${condition.timePeriod} hours`;
                    break;
            }
            $scope.details['Condition for '] = $scope.rule.conditionMustBeMet == true ? 'passing' : 'failing';
            $scope.details['Description'] = $scope.rule.description;

            $scope.details['Activating on'] = ($scope.rule.hasOwnProperty('hostcontexts') && $scope.rule.hostcontexts !== null) ?
                $scope.rule.hostcontexts.name :
                'All hosts';
        }
    };
}]);

reports.directive('ruleDescription', ['$filter', function ($filter) {
    return {
        replace: true,
        restrict: 'A',
        scope: {
            rule: '='
        },
        template: `
        <div class="ruleDescription margin-top">
           {{ description }}
        </div>`,
        controller: function ($scope) {
            let condition;
            const InventoryConditionsMap = {
                "matches": "must match",
                "doesn't match": "must not match",
                "is": "must be",
                "is not": "must not be",
                "regex matches": "must match the regular expression",
                "regex doesn't match": "must not match the regular expression",
                "is reported": "must be reported",
                "is not reported": "must not be reported"
            }
            const status = () => $scope.rule.conditionMustBeMet == 'true' ? 'passing' : 'failing';
            $scope.$watch('rule', () => {
                $scope.description = "";
                switch ($scope.rule.type) {
                    case 'policy':
                        condition = $scope.rule.policyConditions;
                        if (!condition.promiseoutcome) return;
                        $scope.description = `Hosts where `;
                        if (condition.filterBy != undefined && condition.filterItemName != undefined) {
                            $scope.description += `promises filtered by '${condition.filterBy.capitalizeFirstLetter()}' is '${condition.filterItemName}' `;
                        } else  {
                            $scope.description += 'all promises ';
                        }
                       $scope.description += `are '${condition.promiseoutcome}' are considered ${status()}`
                        break;
                    case 'inventory':
                        if (!$scope.rule.inventoryConditions || !$scope.rule.inventoryConditions.filters) return;
                        for (const filter of $scope.rule.inventoryConditions.filters) {
                            const condition = $filter('FilterConditionLabel')(filter.condition, filter);
                            const value = filter.value ? `'${filter.value}'` : '';
                            $scope.description += `${$scope.description.length > 0 ? ' and ' : ''}'${filter.label}' ${InventoryConditionsMap[condition] ?? condition} ${value}`;
                        }
                        $scope.description += $scope.rule.conditionMustBeMet == 'true' ?
                            ' for the check to pass, otherwise it will fail' :
                            ' for the check to fail, otherwise it will pass';
                        break;
                    case 'softwareupdate':
                        condition = $scope.rule.softwareUpdateConditions;
                        const packageName = condition != null && condition.patchname != '' ? condition.patchname : 'All';
                        const architecture = condition != null && condition.patcharchitecture != '' ? condition.patcharchitecture : 'All';
                        $scope.description = `Hosts where software updates are available for package '${packageName}' and architecture '${architecture}' are considered ${status()}`
                        break;
                    case 'custom':
                        $scope.description = `Hosts returned by the query are considered ${status()}`;
                        break;
                    case 'fileChanged':
                        condition = $scope.rule.fileChangedConditions;
                        $scope.description = `Hosts where file name ${condition.condition} '${condition.fileName || ''}' is changed within ${condition.timePeriod} hours are considered ${status()}`
                        break;
                }
            }, true)
        }
    };
}]);
