/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global angular, BaseController, CHANGES_STRING_CONDITION, CHANGES_LIST_CONDITION  */
'use strict';

/**
 *  Directive
 *
 * Use of Class.js
 *
 */
var changesFilterDirectiveCtrl = BaseController.extend({
     init: function ($scope, $elm, $attrs, $q) {
        var self = this;
        this._super($scope);
        this._element = $elm;
        this._attrs   = $attrs;
        this._$q      = $q;

        self.$scope.filters = []; // all selected filters collected here, and only after user click apply we will move them to the SQL filter

        self.$scope.CHANGES_STRING_CONDITION  = CHANGES_STRING_CONDITION;
        self.$scope.CHANGES_LIST_CONDITION    = CHANGES_LIST_CONDITION;

        self._prepareChangesVariables(self.$scope.changesVariables);
    },

    defineScope: function () {
        var self = this;
        self.$scope.addFilter    = this.addFilter.bind(this);
        self.$scope.applyFilter  = this.applyFilter.bind(this);
        self.$scope.updateFilterState = this.updateFilterState.bind(this);
        self.$scope.removeFilter      = this.removeFilter.bind(this);
        self.$scope.clearAll     = this.clearAll.bind(this);
    },

    defineListeners: function () {
        var self = this;

        // got message to apply filters from apply button via environment
        self.$scope.$on("environmentFilter_EVENT", function (event) {
            self.applyFilter();
        });

        self.$scope.$on("clearAll_EVENT", function (event) {
            self.clearAll();
        });

        self.$scope.$on("changesReportLoaded_EVENT", function (event, SQL) {
            self.$scope.filters = SQL.filters;
            self._runReport();
        });

    },

    _prepareChangesVariables: function () {
        this.$scope.changesVariables = CHANGES_FILTERS; /// FROM DCA
        this.$scope.$emit('changesDirectiveReady_EVENT'); // notify that we loaded all variables
    },

    addFilter: function (field, index) {
        var self = this;
        if (angular.equals({}, field)) {
            return;
        }

        var filterField = {};
        angular.copy(field, filterField);
        self.$scope.filters = self.$scope.filters ? self.$scope.filters : [];

        if (index !== undefined) {
            // overwrite
            self.$scope.filters[index] = filterField;
            // set default condition
            if (!self.$scope.filters[index].condition) {
                self.$scope.filters[index].condition = self._setDefaultCondition(field.type);
            }
        } else {
            // add new filter
            self.$scope.filters.push(filterField);
        }

    },

    _setDefaultCondition: function(type) {
        var self = this;
        return self.$scope.CHANGES_STRING_CONDITION[0].value;
    },

    /**
     * Apply filters
     */
    applyFilter: function() {
        var self = this;
        self._runReport();
        self.$scope.showAllFilters = false;
    },

    updateFilterState: function () {

    },

    removeFilter: function (idx) {
        var self = this;
        var key = self.$scope.filters[idx].attribute_name;
        self.$scope.filters.splice(idx, 1);
        self._runReport();

    },

    clearAll: function () {
        var self = this;
        self.$scope.filters = [];
        // broadcast to update env?
    },

    _runReport: function () {
        var self = this;
        // run the report with up to date filter data
        self.$scope.$emit('runQuery_EVENT');
    }
});