<?php

class CategorizationsImporter extends BaseDataImporter
{
    public function isOnlyForAdmin(): bool
    {
        return false;
    }

    public function import($data)
    {
        $data = json_decode($data, JSON_OBJECT_AS_ARRAY);
        foreach ($data as $category) {
            $this->db->reset_query();
            //set current user name in case of non admin user
            $category['username'] = $this->isAdmin === true ? $category['username'] : $this->username;

            $filter = [
                'profileid' => $category['profileid'],
                'username' => $category['username']
            ];
            $exist = $this->db->get_where('astrolabeprofile', $filter);

            $category['defaulttree'] = boolval($category['defaulttree']) == true ? 't' : 'f';
            $category['globaltree'] = boolval($category['globaltree']) == true ? 't' : 'f';

            unset($category['id']);
            if ($exist->num_rows() == 0) {
                $this->db->insert('astrolabeprofile', $category);
            } elseif ($this->skipDuplicates == 0) {
                $this->db->update('astrolabeprofile', $category, $filter);
            }
        }
    }
}
