<?php

class Analyzer extends Cf_Controller
{

    function __construct()
    {
        parent::__construct();
        setCurrentApplication('policy');
        $this->load->library('ion_auth');
    }

    /**
     * @rbacName View policy analyzer page
     * @rbacGroup Policy analyzer
     * @rbacAlias analyzer.index
     */
    function index()
    {
        $requiredcss = array(
            array('angularjs-ui/angular-ui.css'),
            array('/../scripts/libs/jstree/jqueryFileTree.css')
        );

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = array(
            array('node_modules/underscore/underscore-min.js'),
            array('node_modules/angular/angular.min.js'),
            array('node_modules/angular-route/angular-route.min.js'),
            array('node_modules/angular-cookies/angular-cookies.min.js'),
            array('node_modules/angular-sanitize/angular-sanitize.min.js'),

            // services
            array('libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'),
            array('libs/class.js'),

            array('node_modules/angular-chosen-localytics/dist/angular-chosen.min.js'),

            array('node_modules/ace-builds/src-min-noconflict/ace.js'),
            array('node_modules/ace-builds/src-min-noconflict/mode-html.js'),
            array('node_modules/ace-builds/src-min-noconflict/theme-github.js'),
            array('node_modules/ace-builds/src-min-noconflict/theme-tomorrow_night.js'),
        );

        $requiredjs = array(// project
            array('libs/baseclasses/BaseController.js'),
            array('libs/baseclasses/EventDispatcher.js'),
            array('libs/baseclasses/Notifications.js'),

            array('common_directives/hostsInclude/services/paginationService.js'),
            array('common_directives/environment/services/naviTreeService.js'),
            array('policyAnalyzer/app.js'),
            array('policyAnalyzer/controllers/analyzerController.js'),
            array('policyAnalyzer/services/policyService.js'),
            array('policyAnalyzer/services/policySummaryService.js'),
            array('advancedreports/services/reportService.js'),
            array('policyAnalyzer/directives/policyFileExplorer.js'),
            array('policyAnalyzer/directives/policyEditor.js'),
            array('policyAnalyzer/directives/policySummary.js'),
            array('policyAnalyzer/directives/policyFilter.js'),
            array('policyAnalyzer/directives/chosenHostAutoComplete.js'),

            //inventory directive (for filter)
            array('advancedreports/dca.js'),
            array('advancedreports/services/notificationService.js'),
            array('common_directives/inventory/services/inventoryDataService.js'),
            array('common_directives/inventory/services/inventoryFilterService.js'),
            array('common_directives/inventory/inventory_dca.js'),
            array('common_directives/inventory/services/inventoryService.js'),
            array('common_directives/inventory/helpers/inventoryHelper.js'),
            array('common_directives/inventory/directives/inventoryFilterDirectiveCtrl.js'),
            array('common_directives/inventory/directives/inventoryFilter_directive.js'),
            array('common_directives/objectsFilter.js'),

            // hosts include exclude selector
            array('dashboard/helpers/commonHelper.js'),
            array('common_directives/hostsInclude/services/paginationService.js'),
            array('common_directives/hostsInclude/services/includeExcludeService.js'),
            array('common_directives/hostsInclude/services/autocompleteService.js'),
            array('common_directives/hostsInclude/services/naviTreeService.js'),
            array('common_directives/hostsInclude/directives/include_exclude_directive.js'),
            array('common_directives/hostsInclude/directives/includeExcludeSelectionDirective.js'),

            // action service to trigger an agent run after enabling the Policy analyzer
            array('common_directives/actions/actionService.js'),
            array('common_directives/actions/actionHelper.js'),
        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = array('title' => 'Mission Portal - Policy analyzer');

        $this->template->load('template', 'policy/analyzer', $data);
    }


    function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }

}