<?php


/**
 * Class rbac_generator
 *
 * CLI command to generate SQL to insert/updated/delete rbac rules
 * Insert generated SQL code into settings schema sql file
 */
class Rbac_generator extends Cli_Controller
{

    public function __construct()
    {
        parent::__construct();

        if (CLI === false) {
            throw new Exception("You must run this in CLI mode");
        }

        $this->authorizePestByCFRobot();
        $this->load->model('rbac_generator_model');
        $this->load->model('rbac_model');
        $this->rbac_model->setRestClient($this->http_client);
    }

    public function index()
    {
        $permissionList = $this->rbac_model->getPermissionList();
        $this->rbac_generator_model->setPermissionList($permissionList);
        echo $this->rbac_generator_model->generateSQL(FCPATH);
    }



}
