'use strict';

var groupsApp = angular.module('groupsApp', [
        'ngSanitize',
        'ngRoute',
        'notifications',
        'ui.bootstrap',
        'ngCookies',
        'personalGroupsServiceModule',
        'sharedGroupsServiceModule',
        'inclExcl.paginationServiceModule',
        'notificationServiceModule',
        'inventoryServiceModule',
        'inventoryDirectives',
        'inventoryHelpers',
        'inventoryDataServiceModule',
        'inventoryFilterServiceModule',
        'customFilter',
        'inclExclDirectives',
        'inclExcl.naviTreeService',
        'includeExcludeServiceModule',
        'autoCompleteServiceModule',
        'commonHelper',
        'commonHelperModule',
        'commonFiltersModule',
        'dc.naviTreeService',
        'tableDirectiveModule',
        'highChartsDirective',
        'reportServiceModule',
        'editableFieldModule',
        'cmdbServiceServiceModule',
        'cmdbDirectivesModule'
    ],
    function ($routeProvider, $locationProvider) {
        $locationProvider.hashPrefix('');

        $routeProvider.when('/', {
            templateUrl: MP_SITE_URL + '/groups_app/groups/partials/groups/index',
            controller: personalGroupsListController
        });


        $routeProvider.when('/personal/:id', {
            templateUrl: MP_SITE_URL + '/groups_app/groups/partials/groups/group',
            controller: personalGroupController
        });

        $routeProvider.when('/personal/:id/data', {
            templateUrl: MP_SITE_URL + '/groups_app/groups/partials/groups/data',
            controller: personalGroupDataController
        });

        $routeProvider.when('/shared/:id', {
            templateUrl: MP_SITE_URL + '/groups_app/groups/partials/groups/group',
            controller: sharedGroupController
        });

        $routeProvider.when('/shared/:id/data', {
            templateUrl: MP_SITE_URL + '/groups_app/groups/partials/groups/data',
            controller: sharedGroupDataController
        });

        $routeProvider.when('/shared', {
            templateUrl: MP_SITE_URL + '/groups_app/groups/partials/groups/index',
            controller: sharedGroupsListController
        });

        $locationProvider.html5Mode(true);
    }
);

groupsApp.factory('authHttpResponseInterceptor',['$q','$location',function($q){
    return {
        response: function(response){
            if (response.status === 401) {
                unAuthorizedHandler();
            }
            return response || $q.when(response);
        },
        responseError: function(rejection) {
            if (rejection.status === 401) {
                unAuthorizedHandler();
            }
            return $q.reject(rejection);
        }
    }
}]);

groupsApp.config(['$httpProvider', '$provide', function($httpProvider, $provide) {
        //This header was removed from recent version of angular.
        // PHP looks at this header to separate request between regular and AJAX.
        $httpProvider.defaults.headers.common["X-Requested-With"] = 'XMLHttpRequest';
        // IE fix to prevent caching
        $httpProvider.defaults.headers.common["If-Modified-Since"] = 0;
        // add interceptor to httpProvider
        $httpProvider.interceptors.push('authHttpResponseInterceptor');

        $provide.decorator('$exceptionHandler',
        ['$delegate', errorLogger]);
}]);

function errorLogger($delegate) {
    return function (exception, cause) {
        $delegate(exception, cause);
        var msg = exception.message + "\n" + exception.stack;
        globalLogger.sendErrorToServer(msg)
    };
}
