<?php

//******************************* M O D A L *******************************************************
$this->load->view('/partials/_saveSearchModal');
$this->load->view('/partials/_copySearchModal');
//******************************* M O D A L *******************************************************
?>

<div class="pageTitle">
    <h1><?= $title ?></h1>
    <h3><?= $description ?></h3>
</div>


<ul id="accordion">
    <h3>Common causes</h3>
    <?php foreach ($recommendations as $index => $recommendation) { ?>
        <li>
        <div id="heading<?= $index ?>">
            <a class="titleLink" data-toggle="collapse" data-target="#collapse<?= $index ?>" aria-expanded="true"
               aria-controls="collapse<?= $index ?>">
                    <?= $recommendation['question'] ?>
            </a>
        </div>

        <div id="collapse<?= $index ?>" class="collapse show" aria-labelledby="heading<?= $index ?>" data-parent="#accordion">
            <div class="card-body">
	            <?= $recommendation['response'] ?>
            </div>
        </div>
        </li>
	<?php } ?>
</ul>

<style>
    .titleLink {
        border-bottom: 1px #008cbc dashed;
    }

    .titleLink:hover {
        text-decoration: none;
    }
    .hd_buttons #save_report, .hd_buttons .schedule_report {display: none;}

</style>
<div style="margin-top:20px">

    <div ng-show="reportLabel != ''">
        <h3 ng-if="reportLabel != ''">{{reportLabel}}</h3>
    </div>
    <span class="muted">{{SQL.hostcontexts.name}}</span>
    <?php $this->load->view('/partials/_notification'); ?>
    <textarea style="display:none;" sql-ready  id="angularSQLString" data-type="<?= $type ?>"><?= $sql ?></textarea>

    <input type="hidden" value="{{VIEW.sortColumn}}" id="angularSQLSortColumn">
    <input type="hidden" value="{{VIEW.sortDescending}}" id="angularSQLSortDescending">
    <input type="hidden" value="{{SQL.hostcontexts.includes | json}}"  id="angularhostsContextInclude">

    <div class="sql-result-block row-fluid margin-top" ng-show="VIEW.rowCount > 0">

    <?php
        $this->load->view('/partials/_pagination');
    ?>

        <div class="horizontal-scroll sql-result-table-wrapper margin-bottom">
            <table class="table table-bordered float-left margin-top">
                <thead>
                    <tr>
                        <th ng-class="{'sort-head':$index!=0, 'deleteCheck':$index==0}" ng-repeat="head in VIEW.tablehead track by $index" ng-click="$index !=0 ? sortReorder(head.nameToSort, $event): ''">
                            <span ng-if="$index!=0">{{head.name}}<i ng-class="{'icon-chevron-up':head.sort<0,'icon-chevron-down':head.sort>0}"></i></span>
                            <span ng-if="$index==0"><input type="checkbox" ng-model="selectedAllDeleteHost" ng-click="checkAllDeleteHost()"> </span>
                        </th>
                    </tr>
                </thead>
                <tbody >
                <tr ng-repeat="rows in VIEW.rows track by $index">
                    <td ng-repeat="col in rows track by $index" ng-class="{'deleteCheck':$index==0}">
                        <span ng-if="$index != 0" ng-bind-html="col"></span>
                        <span ng-if="$index == 0"><input type="checkbox" ng-model="selectedHostsList[col].checked"></span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <?php
            $this->load->view('/partials/_pagination');
        ?>
    </div>
</div>

<div id="resultScrollTo" class="margin-top hd_buttons">
<?php
    $data['buttonPosition'] = "bottom";
    $this->load->view('/partials/elements/_resultPageBtn', $data);
?>
</div>

<hr />
<div ng-if="dismissedHosts.rows.length > 0">
    <a class="titleLink" data-toggle="collapse" data-target="#dismissed" aria-expanded="true" aria-controls="collapse4">
        Show dismissed host </a>

    <div id="dismissed" class="collapse show" >
        <div class="horizontal-scroll sql-result-table-wrapper margin-bottom">
            <table class="table table-bordered float-left margin-top">
                <thead>
                <tr>
                    <th ng-class="{'sort-head':$index!=0, 'deleteCheck':$index==0}" ng-repeat="head in dismissedHosts.header track by $index" ng-click="$index !=0 ? sortReorder(head.nameToSort, $event): ''">
                        <span ng-if="$index!=0">{{head.columnName}}<i ng-class="{'icon-chevron-up':head.sort<0,'icon-chevron-down':head.sort>0}"></i></span>
                        <span ng-if="$index==0"><input type="checkbox" ng-model="selectedAllDismissHost" ng-click="checkAllDismissHost()"> </span>
                    </th>
                </tr>
                </thead>
                <tbody >
                <tr ng-repeat="rows in dismissedHosts.rows track by $index">
                    <td ng-repeat="col in rows track by $index" ng-class="{'deleteCheck':$index==0}">
                        <span ng-if="$index != 0" ng-bind-html="col"></span>
                        <span ng-if="$index == 0"><input type="checkbox" ng-model="selectedDismissList[col].checked"></span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>

        <p class="pull-left">
            <button class="btn btn-large"  ng-click="removeFromDismissed()">Remove from dismissed</button>
        </p>

    </div>
</div>

<div class="pull-right go-to-top"><i class="icon-arrow-up"></i></div>
<div class="pull-right go-to-bottom"><i class="icon-arrow-down"></i></div>