<?php

namespace FR\V1_0\Entities\Transports;

use FR\Interfaces\TransportInterface;

class TransportEntityFactory
{
    private static $transportMap = [
        'push_over_rsync' => BaseRsyncTransport::class,
        'pull_over_rsync' => BaseRsyncTransport::class
    ];

    public static function create($mode): TransportInterface
    {
        if (!in_array($mode, array_keys(self::$transportMap))) {
            throw new \ResponseException('Transport mode is invalid', \Response::BADREQUEST);
        }

        /**
         * @var $entity TransportInterface
         */
        $entity = new self::$transportMap[$mode];
        $entity->setMode($mode);
        return $entity;
    }
}
