<?php


class Cmdb_model extends Cf_Model
{
    private $endpoint = '/cmdb';

    public function getItem($hostkey)
    {
        return json_decode($this->getRestClient()->get("{$this->endpoint}/$hostkey"), $associative = true);
    }

    public function updateItem($hostkey, $type, $name, $value)
    {
        $this->getRestClient()->patch("{$this->endpoint}/$hostkey/$type/$name/", $value);
    }

    public function createItem($hostkey, $type, $name, $value)
    {
        $this->getRestClient()->post("{$this->endpoint}/$hostkey/$type/$name/", $value);
    }

    public function deleteItem($hostkey, $type, $name)
    {
        return $this->getRestClient()->delete("{$this->endpoint}/$hostkey/$type/$name/");
    }

    public function getItemByName($hostkey, $type, $name)
    {
        return $this->getRestClient()->get("{$this->endpoint}/$hostkey/$type/$name/");
    }
}
