<?php

namespace Build\Entities;

class ModuleEntity
{
    private $name;
    private $description;
    private $readme;
    private $version;
    private $author;
    private $updated;
    private $downloads;
    private $repo;
    private $documentation;
    private $website;
    private $subdirectory;
    private $commit;
    private $dependencies;
    private $tags;
    private $versions;
    private $latest;

    public static function fromArray(array $module) : self
    {
        $item = new ModuleEntity();
        foreach ($module as $key => $value) {
            if (property_exists($item, $key)) {
                $item->{"set" . ucfirst($key)}($value);
            }
            if ($key == 'id') {
                $item->setName($value);
            }
        }
        return $item;
    }

    public function toArray() : array
    {
        return [
            'name' => $this->getName(),
            'description' => $this->getDescription(),
            'readme' => $this->getReadme(),
            'version' => $this->getVersion(),
            'author' => json_encode($this->getAuthor()),
            'updated' => $this->getUpdated(),
            'downloads' => $this->getDownloads(),
            'repo' => $this->getRepo(),
            'documentation' => $this->getDocumentation(),
            'website' => $this->getWebsite(),
            'subdirectory' => $this->getSubdirectory(),
            'commit' => $this->getCommit(),
            'dependencies' => json_encode($this->getDependencies()),
            'tags' => json_encode($this->getTags()),
            'versions' => json_encode($this->getVersions()),
            'latest' => $this->getLatest() ? 'true' : 'false'
        ];
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setDescription($description)
    {
        $this->description = $description;
    }

    public function getReadme()
    {
        return $this->readme;
    }

    public function setReadme($readme)
    {
        $this->readme = $readme;
    }

    public function getVersion()
    {
        return $this->version;
    }

    public function setVersion($version)
    {
        $this->version = $version;
    }

    public function getAuthor()
    {
        return $this->author;
    }

    public function setAuthor($author)
    {
        $this->author = $author;
    }

    public function getUpdated()
    {
        return $this->updated;
    }

    public function setUpdated($updated)
    {
        $this->updated = $updated;
    }

    public function getDownloads()
    {
        return $this->downloads;
    }

    public function setDownloads($downloads)
    {
        $this->downloads = $downloads;
    }

    public function getRepo()
    {
        return $this->repo;
    }

    public function setRepo($repo)
    {
        $this->repo = $repo;
    }

    public function getDocumentation()
    {
        return $this->documentation;
    }

    public function setDocumentation($documentation)
    {
        $this->documentation = $documentation;
    }

    public function getWebsite()
    {
        return $this->website;
    }

    public function setWebsite($website)
    {
        $this->website = $website;
    }

    public function getSubdirectory()
    {
        return $this->subdirectory;
    }

    public function setSubdirectory($subdirectory)
    {
        $this->subdirectory = $subdirectory;
    }

    public function getCommit()
    {
        return $this->commit;
    }

    public function setCommit($commit)
    {
        $this->commit = $commit;
    }

    public function getDependencies()
    {
        return $this->dependencies;
    }

    public function setDependencies($dependencies)
    {
        $this->dependencies = $dependencies;
    }

    public function getTags()
    {
        return $this->tags;
    }

    public function setTags($tags)
    {
        $this->tags = $tags;
    }

    public function getVersions()
    {
        return $this->versions;
    }

    public function setVersions($versions)
    {
        $this->versions = $versions;
    }

    public function getLatest()
    {
        return $this->latest;
    }

    public function setLatest($latest)
    {
        $this->latest = $latest;
    }

}
