
<?php

//******************************* M O D A L *******************************************************
$this->load->view('/partials/_saveSearchModal');
$this->load->view('/partials/_copySearchModal');
//******************************* M O D A L *******************************************************
?>
<div class="flex flex-space-between flex--align_center">
    <ol class="breadcrumb margin-top">
        <li><a href="<?= site_url('reports') ?>">Reports</a></li>
        <li class="active">Inventory</li>
    </ol>
    <span rel="tooltip" id="tab-context-help-icon" class="CFE-context-help help" data-key="inventory" data-title="Inventory" data data-placement='left' title="Click for help">
           Help <i  class="bi bi-question-circle-fill" > </i>
    </span>
</div>
<div class="pageTitle inventory-title">
    <h1>
        <span>Inventory</span>
    </h1>
</div>

    <div ng-show="reportLabel != ''">
        <h3 class="margin-bottom" ng-if="reportLabel != ''">Results for {{reportLabel}}</h3>
    </div>

    <input type="hidden" value="{{SQL.SQLSTRING}}" id="angularSQLString">
<div class="sql-result-block margin-top row-fluid">

    <div class="inventory-top">
        <div class="flex-grow_1">
            <div class="accordion-group">
                <btn ng-class="{'pressed':showFilter}"
                     ng-click="showFilter=!showFilter"
                     class="btn btn-dark-blue inv-filter"
                     data-parent="#filterTree"
                     data-toggle="collapse">
                        <span id="filterToggle">
                            <i class="bi bi-filter"></i>
                            Filter <span ng-show="originalFilters.length"
                                         class="help-block inline"
                                         style="font-size:14px; font-style:normal">({{originalFilters.length}})</span>
                        </span>
                </btn>
            </div>
            <div id="filterTree" class="filterTreeInv" ng-init="showFilter=false" ng-class="{'open':showFilter}">
                <div ng-show="showFilter" class="margin-left-small">
                    <div class="margin-top margin-bottom-small" id="variableFilters">
                        <div class="inventoryfilter"
                             ui="UI"
                             sql="SQL"
                             include-classes="true"
                             showfilterapplybtn="true"
                             applicationname='inventory_report'
                             cfemappingremovefields="CFE_Mapping_removeFields"
                             cfemappingaddfields="CFE_Mapping_addFields"
                             cfemappingaddtofilters="CFE_Mapping_addToFilters"
                        >
                        </div>
                    </div>
                    <div include-exclude-by-hostkey
                         excluded-hosts="SQL.hostsFilters.excludes"
                         included-hosts="SQL.hostsFilters.includes"
                    >

                    </div>
                    <div class="filterButtons">
                        <div class="filter-buttons inline-block">
                            <span>
                                <a class="margin-right-small" ng-href="" ng-click="clearAll()">
                                    <i class="bi bi-trash"></i>Clear all
                                </a>
                            </span>
                            <button class="btn btn-secondary" ng-click="showFilter=false">Cancel</button>
                            <button class="btn btn-primary" ng-click="runReport();showFilter=false;">Apply</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="resultScrollTo" class="margin-top">
            <?php
            $data['buttonPosition'] = "bottom";
            $data['showEdit'] = false;
            $this->load->view('/partials/elements/_resultPageBtn', $data);
            ?>
        </div>
    </div>
    <div ng-show="!VIEW.rowCount">
        <?php $this->load->view('/partials/_notification'); ?>
    </div>
    <div ng-show="VIEW.rowCount" class="horizontal-scroll sql-result-table-wrapper margin-bottom">
        <table id="inventory-table" class="table table-bordered float-left" style="margin-bottom:0">
            <thead>
            <tr>
                <th id="header{{$index}}" class="sort-head" ng-repeat="head in VIEW.tablehead" ng-click="sortReorder(head.nameToSort, $event)">
                    <div style="width:100%; margin-right:32px;position:relative">
                        <span>{{head.name}}</span>
                        <i class="bi " ng-class="{'bi-caret-up-fill':head.sort<0,'bi-caret-down-fill':head.sort>0}"></i>
                        <i class="placeholder-icon icon-reorder"></i>
                    </div>
                </th>
            </tr>
            </thead>
            <tbody tr-rows rowdata="VIEW.rows" tablehead="VIEW.tablehead" replaceNull="true">
            </tbody>
        </table>
    </div>

    <div style="position:relative;z-index:3">
        <div ng-repeat="head in VIEW.tablehead" ng-class="{'last':$last}" column-index="{{$index}}" column-dropdown class="column-dropdown" ng-cloak id="dropdown{{$index}}">
        </div>
    </div>

    <div ng-show="VIEW.rowCount">
        <?php
        $this->load->view('/partials/_pagination');
        ?>
    </div>
</div>
<input type="hidden" value="{{VIEW.sortColumn}}" id="angularSQLSortColumn">
<input type="hidden" value="{{VIEW.sortDescending}}" id="angularSQLSortDescending">
<input type="hidden" value="{{SQL.hostcontexts.includes | json}}"  id="angularhostsContextInclude">

    <input type="hidden" value="{{SQL.excludedHosts.excludes | json}}"  id="angularhostsContextExclude">
    <div class="pull-right go-to-top"><i class="icon-arrow-up"></i></div>
    <div class="pull-right go-to-bottom"><i class="icon-arrow-down"></i></div>
</div>
<?php  $this->load->view('/partials/_showChartModal'); ?>

<script type="text/ng-template" id="insertColumnsModal.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
            <i class="bi bi-x"></i></button>
        <h2>Add columns</h2>
    </div>
    <div class="modal-body">
        <div class="searchAttribute">
            <input type="text" ng-model="data.searchAttribute" placeholder="Search for attributes"/>
        </div>
        <div>
            <h4>Active columns</h4>
            <ul class="sortable unstyled" ui-sortable="sortableColumnsConfig" ng-model="selectedCols">
                <li class="active-column" ng-repeat="column in selectedCols track by $index">
                    <span ng-click="$event.stopPropagation();" class="active-column-sortable">{{ column }}
                        <i class="bi bi-x-circle-fill" ng-click="removeColumn($index)"></i>
                    </span>
                </li>
            </ul>
            <div class="warning" ng-if="!selectedCols.length">Please select at least one column</div>
        </div>
        <hr/>
        <div>
            <ul class="attributes-list">
                <li class="addColumn" ng-repeat="key in noSort(UI.InventoryItems.groups)"
                    ng-init="value=UI.InventoryItems.groups[key]">
                    <h4 ng-show="filteredCols.length">{{value[0].category}}</h4>
                    <ul class="unstyled" ng-show="value">
                        <li ng-repeat="item in filteredCols = (value | filter:data.searchAttribute)"
                            ng-class="{selected: isColumnSelected(item.label)}">
                            <div ng-if="!isColumnSelected(item.label)" class="flex flex-space-between">
                                <div ng-bind-html="highlightSearch(item.label, data.searchAttribute)">{{item.label}}
                                </div>
                                <a ng-click="$event.stopPropagation(); selectedCols.push(item.label)">
                                    <i class="bi bi-plus"></i> Add
                                </a>
                            </div>

                            <span ng-if="isColumnSelected(item.label)"
                                  ng-bind-html="highlightSearch(item.label, data.searchAttribute)"
                                  class="muted">{{item.label}}</span>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>

    </div>
    <div class="modal-footer">
        <button class="btn btn-large" data-dismiss="modal" ng-click="close()" >Cancel</button>
        <button ng-disabled="!selectedCols.length" class="btn btn-large btn-primary" ng-click="apply()">Done</button>
    </div>
</script>
