<?php

include_once __DIR__ . '/inventoryWidgets/autoload.php';

class InventoryWidgetLibrary
{
    /**
     * @param $name
     * @param $type
     * @param HttpClientInterface $restClient
     * @return array
     *
     */
    public function getStatisticByAttributeName($name, $type, HttpClientInterface $restClient)
    {
        $className = null;

        switch ($type) {
            case  'bar':
            case  'pie':
            case  'table':
                $className = 'BarPieChart';
                break;
            case 'solidgauge':
                $className = 'SolidGaugeChart';
                break;
        }

        if (class_exists($className)) {
            /**
             * @var $obj BaseInventoryWidget
             */
            $obj = new $className;
        } else {
            throw new InvalidArgumentException("Implementation for $type inventory widget does not exist");
        }

        return $obj->getStatistics($name, $restClient);
    }
}