#!/bin/bash
#
# cfengine3
# 
#
# Created by Nakarin Phooripoom on 22/6/2011.
# Copyright 2021 Northern.tech AS.
#
### BEGIN INIT INFO
# Provides:          cfengine3
# Required-Start:    $local_fs $remote_fs $network $time
# Required-Stop:     $local_fs $remote_fs $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: GNU configuration engine
# Description:       Tool for configuring and maintaining network machines
### END INIT INFO
#
# chkconfig: 2345 60 40
# description: Starts the daemons specific to nova-hub.
# set -e

##### start: Defined variables and conditios #####

# Since this script is expected to be sourced from the Community script, we can
# also use variables from there.

PREFIX=/var/cfengine

CFHUB=$PREFIX/bin/cf-hub
CFREACTOR=$PREFIX/bin/cf-reactor
CFHTTPD=$PREFIX/httpd/bin/httpd
CFPOSTGRES=$PREFIX/bin/postgres
PGCTL=$PREFIX/bin/pg_ctl
RUNALERTS=$PREFIX/bin/runalerts.php
POSTGRESQL_DATA=$PREFIX/state/pg/data
POSTGRESQL_LOG=/var/log/postgresql.log
HA_CONFIG_FILE=$PREFIX/ha.cfg

##### end: Defined variables and conditions #####

### start scripting here ###

start_postgres()
{
    # start CFEngine Postgresql
    if [ -x $PGCTL ] && [ ! -f $HA_CONFIG_FILE ]; then
        echo "Starting CFEngine postgresql: "
        ORIG_PWD=`pwd`
        cd /tmp && su cfpostgres -c "$PGCTL -w -D $POSTGRESQL_DATA -l $POSTGRESQL_LOG start"
        cd "$ORIG_PWD"
        echo
    elif [ -f $HA_CONFIG_FILE ]; then
        echo "Skipping CFEngine postgresql: detected HA configuration $HA_CONFIG_FILE."
        echo "         postgresl-hub is managed by the cluster."
        echo
    fi
}

cf_php_fpm_service()
{
    # cf-php-fpm service
    local _script=/etc/init.d/cf-php-fpm
    if [ -x "$_script" ]; then
        "$_script" "$1"
    else
        echo "Error: Missing $_script script. Mission Portal will not operate without this service."
    fi
}

start_httpd()
{
    # start CFEngine httpd
    echo -n "Starting CFEngine `basename $CFHTTPD`: "
    LD_LIBRARY_PATH=$PREFIX/lib:$LD_LIBRARY_PATH $PREFIX/httpd/bin/apachectl start
    echo
}

start_cf_hub()
{
    # start cf-hub
    if [ -f $PREFIX/state/am_policy_hub ]; then
        cf_start_daemon $CFHUB
    fi
}

start_cf_reactor()
{
    # start cf-reactor
    if [ -f $PREFIX/state/am_policy_reactor ]; then
        cf_start_daemon $CFREACTOR
    fi
}

enterprise_start()
{
    if [ "$CF_NO_WEB_SERVICES" != "1" ]; then
        start_postgres
        start_httpd
        cf_php_fpm_service start
    fi

    if [ "$CF_ONLY_WEB_SERVICES" = "1" ]; then
        return 0
    fi

    start_cf_hub
    start_cf_reactor
}

enterprise_stop()
{
    if [ "$CF_ONLY_WEB_SERVICES" != "1" ]; then
        echo -n "Shutting down `basename $RUNALERTS`"
        pkill -f $RUNALERTS || true
        echo

        # shutdown cf-hub
        cf_stop_daemon $CFHUB

        # shutdown cf-reactor
        cf_stop_daemon $CFREACTOR
    fi

    if [ "$CF_NO_WEB_SERVICES" = "1" ]; then
        return 0
    fi

    # shutdown CFEngine httpd
    local cfhttpd_status="$(cf_get_matching_pids $CFHTTPD)"
    if [ "$cfhttpd_status" ]; then
        echo -n "Shutting down CFEngine `basename $CFHTTPD` ..."
        LD_LIBRARY_PATH=$PREFIX/lib:$LD_LIBRARY_PATH $PREFIX/httpd/bin/apachectl stop
        echo
    fi

    # shutdown CFEngine Postgresql
    local postgresql_status="$(cf_get_matching_pids --ignore-user $CFPOSTGRES)"
    if [ "$postgresql_status" ] && [ ! -f $HA_CONFIG_FILE ]; then
        echo -n "Shutting down CFEngine postgresql ... "
        cd /tmp && su cfpostgres -c "$PGCTL -D $POSTGRESQL_DATA -l $POSTGRESQL_LOG -m fast stop"
        echo
    elif [ -f $HA_CONFIG_FILE ]; then
        echo "Skipping CFEngine postgresql: detected HA configuration $HA_CONFIG_FILE."
        echo "         postgresl-hub is managed by the cluster."
        echo
    fi

    # shutdown cf-php-fpm
    cf_php_fpm_service stop
}

enterprise_status()
{
    if [ "$CF_ONLY_WEB_SERVICES" != "1" ]; then
        # status cf-hub
        cf_status_daemon $CFHUB

        # status cf-reactor
        cf_status_daemon $CFREACTOR
    fi

    if [ "$CF_NO_WEB_SERVICES" = "1" ]; then
        return 0
    fi

    # status CFEngine httpd
    cf_status_daemon $CFHTTPD

    # status CFEngine postgresql
    cf_status_postgres_daemon $POSTGRESQL_DATA

    # status of cf-php-fpm
    cf_php_fpm_service status
}

cf_status_postgres_daemon() {
     local data_directory="$1"
     local pidfile="${data_directory}/postmaster.pid"
     local pids="$(cf_get_matching_pids --ignore-user "postgres")"

     if [ -n "$pids" -a -f "$pidfile" ]; then
         pid_from_file=$(sed -n 1p "$pidfile")
         if [ -n "$(echo "$pids" | egrep -w "$pid_from_file")" ]; then
             echo "postgres is running..."
             return
         fi
     fi

     echo "postgres is not running..."
 }

if [ "$CALLED_FROM_INITSCRIPT" != "1" ] && [ "$CALLED_FROM_STATE_RESTORE" != "1" ]; then
    echo "Should only be called from init or package scripts"
    exit 1
fi
