<main ng-app="hubManagementApp" id="ng-app" style="display: none">
    <div ng-controller="hubManagementController">
        <div class="pageTitle">
            <h1>
                <span>Hub management</span>
            </h1>
        </div>
        <h3>Hub information (this host)</h3>
        <div class="inline-block">
            <hr/>
            <h4 class="muted">Host information</h4>
            <ul class="span6 hub-ul-info">
                <li><span class="muted span2">Host name:</span>
                    <a target="_blank" href="/hosts/{{hubInfo.hostkey}}">{{hubInfo.hostname}}</a>
                </li>
                <li>
                    <span class="muted span2">IPv4 addresses:</span> {{hubInfo.ip}}
                </li>
                <li>
                    <span class="muted span2">Last report time:</span> {{hubInfo.update_ts}}
                </li>
            </ul>
            <ul class="span6 hub-ul-info">
                <li>
                    <span class="muted span2">CFEngine version:</span>{{hubInfo.version}}
                </li>
                <li>
                    <span class="muted span2">Uptime:</span>
                    <span ng-if="hubInfo.uptime_minutes != NAN">{{(hubInfo.uptime_minutes / 3600).toFixed(1)}} days</span>
                </li>
                <li>
                    <a class="span6" target="_blank" href="/hosts/{{hubInfo.hostkey}}">
                        view full host information
                    </a>
                </li>
            </ul>
        </div>
        <hr/>
        <div ng-if="hubStatus.configured === true && hubStatus.role === 'feeder'">
            <div ng-if="superHubData !== null">
                <h4 class="muted">Connected to Superhub</h4>

                <ul class="span6 hub-ul-info">
                    <li><span class="muted span3">Superhub host name:</span>
                        {{superHubData.ui_name}}
                    </li>
                    <li>
                        <span class="muted span3">Superhub URL:</span>
                        {{superHubData.api_url}}
                    </li>
<!--                    <li>-->
<!--                        <span class="muted span3">Last reported:</span> @todo  set here real last reported data-->
<!--                    </li>-->
                </ul>

                <ul class="span6 hub-ul-info">
                    <li>
                        <span class="icon-info-sign muted"></span> <span class="muted">Contact the superhub administrator to make any changes to connection status</span>
                    </li>
                </ul>
            </div>


            <div ng-if="superHubData === null">
                <h4 class="muted">Hub is enabled as Feeder</h4>
            </div>
        </div>
        <div ng-if="hubStatus.configured === false && hubStatus.enable_request_sent === false">
            <div class="enable-superhub-block">
            <span class="muted hub-status-block">
                Enable federated reporting by making this hub a Superhub.
                You can then connect other hubs to it and collect their
                reports in one place.
            </span class="muted">
                <button class="btn btn-large btn-primary margin-bottom margin-top enable-superhub-btn"
                        ng-click="enableSuperhub()">
                    Enable as Superhub
                </button>
            </div>
            <div style="padding: 10px">
                <h4 class="muted">OR</h4>
            </div>
            <div class="enable-feeder-block">
            <span class="muted hub-status-block">
                Allow to collect hub's reports by enabling as a Feeder hub. &nbsp;
                Then this hub can be connected to a Superhub.
            </span>
                <button class="btn btn-large btn-primary margin-bottom margin-top enable-feeder-btn"
                        ng-click="enableFeeder()">
                    Enable as Feeder
                </button>
            </div>
        </div>
        <div ng-if="hubStatus.configured === false && hubStatus.enable_request_sent === true">
            <span class="muted hub-status-block">
                This hub will be configured shortly. Please reload this page in a few minutes.
            </span class="muted">
        </div>
        <div ng-if="hubStatus.target_state == 'off'">
            <span class="muted hub-status-block">
                This Feeder hub will be reverted back to the regular hub shortly.
            </span>
        </div>
        <!-- ENABLED --->
        <section ng-if="hubStatus.configured === true && hubStatus.enable_request_sent === true">
            <button class="btn btn-large btn-primary margin-bottom margin-top pull-right" ng-if="false">
                Disable as Superhub
            </button>
            <span class="clear-both"></span>
            <div class="inline-block" ng-if="false">
                <h4 class="muted">Hub report collection</h4>
                <ul class="span6 hub-ul-info">
                    <li><span class="muted span3">Report collection interval:</span>
                        <button class="btn btn-mini btn-info m-l_20">Edit</button>
                    </li>
                    <li><span class="muted span3">Time taken for last report cycle:</span> <!-- @todo Set real value --> minutes</li>
                    <li><span class="muted span3">Average report cycle time:</span> <!-- @todo Set real value --> minutes</li>
                </ul>
            </div>
        </section>
        <section ng-if="hubStatus.configured === true && hubStatus.role === 'superhub'">
            <div>
                <span class="span2"><h4 class="muted">Connected hubs</h4></span>
                <button class="btn btn-mini btn-info connect-hub-btn" ng-click="openConnectHubModal()">
                    + connect a hub
                </button>
            </div>
            <div class="no-hubs-text">
            <span class="muted clear-both inline-block" ng-if="connectedHubs.length == 0">
                No hubs are connected to the Superhub. Connect a hub to start collecting reports.
            </span>
            </div>
            <table class="table table-striped" ng-if="connectedHubs.length > 0">
                <thead>
                <tr>
                    <th>Host name</th>
                    <th>URL</th>
                    <th># Bootstrapped hosts</th>
                    <th>Status</th>
                    <th>Time of last import</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <tr ng-repeat="hub in connectedHubs track by $index">
                    <td>{{hub.ui_name}}</td>
                    <td>{{hub.api_url}}</td>
                    <td>{{hub.statistics.bootstrappedHostsCount}}</td>
                    <td><span class="alert-{{hub.target_state == 'on' ? 'success' : 'danger'}} padding_5">{{hub.target_state == 'on' ? 'enabled' : 'disabled'}}</span></td>
                    <td>{{hub.statistics.timeOfLastImport || 'n/a'}}</td>
                    <td>
                        <button class="btn btn-mini btn-info" ng-click="openConnectHubModal(hub.id)">edit</button>
                    </td>
                </tr>
                </tbody>
            </table>
        </section>
    </div>

    <script type="text/ng-template" id="connectHubModal.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>{{isEditOperation === true ? 'Edit' : 'Connect'}} a hub</h2>
        </div>
        <div class="row modal-body">
            <div class="text-center">
            <span class="muted inline-block clear-both">
                Connect a hub to the superhub. This will allow the hub's report data to be collected by the superhub.
            </span class="muted">
            </div>
            <form class="form-horizontal confirm-before-leave"  autocomplete="off" method="post">
                <div class="control-group">
                    <label class="control-label" for="hostname_ip">Mission Portal URL</label>
                    <div class="controls">
                        <input ng-required="true" id="hostname_ip" name="hostname_ip" placeholder="https://hub.example.com" ng-model="formData.api_url" type="text" class="input-xlarge">
                        <div class="red" ng-show="validationErrors.api_url != undefined">{{validationErrors.api_url}}</div>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="username">User name</label>
                    <div class="controls">
                        <input ng-class="" id="username" name="username" ng-model="formData.userName" type="text" class="input-xlarge">
                        <div class="red" ng-show="validationErrors.userName != undefined">{{validationErrors.userName}}</div>
                        <span class="help-block">Mission Portal username</span>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for=password"">Password</label>
                    <div class="controls">
                        <input id="password" name="password" ng-model="formData.password" type="password" class="input-xlarge">
                        <?php $this->load->view('common/show-password-btn.php'); ?>
                        <div class="red" ng-show="validationErrors.password != undefined">{{validationErrors.password}}</div>
                        <span class="help-block">Password won't be saved</span>
                    </div>
                </div>
                <input id="transport_method[value]" ng-show="false" ng-model="formData.transport_method"/>
                <div class="control-group" ng-if="false">
                    <label class="control-label">Transport method</label>
                    <div class="controls">
                        <select
                                required
                                data-placeholder="Select transport method"
                                chozen
                                ng-model="formData.transport_method"
                                ng-init="formData.transport_method = transports[0]"
                                ng-options="transport as transport.label for transport in transports track by transport.value"
                        >
                        </select>

                        <div class="margin-top">
                            <span style="line-height: 15px;" class="help-block">Pull: The Superhub will initiate and download reports from the connected hubs.</span>
                            <span style="line-height: 15px;" class="help-block">Push: The connected hubs will connect to the superhub and upload reports.</span>
                        </div>
                    </div>
                </div>
                <div class="control-group" ng-if="false">
                    <label class="control-label" for="ssh_key">Public SSH key</label>
                    <div class="controls">
                        <textarea ng-model="formData.sshKey" id="ssh_key"  class="input-xlarge" rows="6"></textarea>
                        <span class="muted or_file">or</span>
                        <button class="btn btn-small btn-info pull-right" onclick="$('#ssh_file').click()">Upload a file</button>
                        <input id="ssh_file" class="hide" type="file"  ssh-key-loader />
                        <div class="red" ng-show="validationErrors.sshKey != undefined || validationErrors.sshKey != ''">{{validationErrors.sshKey}}</div>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <label><input name="enabled" ng-model="formData.enabled" type="checkbox"/>Enable reporting to superhub</label>
                    </div>
                </div>
                <div id="certificate" class="m-l_20 margin-top-large" ng-if="sslCertError">
                    <div class="divider"></div>
                    <h5>Hub's SSL certificate issuer is unknown or the certificate is self-signed.</h5>
                    <button class="btn btn-large btn-primary" ng-click="formData.skipSslVerification=true;isEditOperation ? editHub() : connectHub(closeModal)">Skip certificate verification and continue</button>
                    <div class="margin-top">
                        <a class="btn btn-large btn-link no-padding" ng-click="showCert=!showCert" onclick="this.scrollIntoView()" href="#certificate">View certificate</a>
                        <div class="margin-top-small" ng-show="showCert" style="word-break: break-word;">
                            <div class="margin-top" ng-repeat="(property,value) in sslCertError.certInfo[0]">
                                <div><b>{{ property }}</b></div>
                                <div class="margin-top-small">{{ value }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-large btn-primary pull-right" ng-click="formData.skipSslVerification=false;editHub()" ng-if="isEditOperation">
                Update connected hub
            </button>
            <button class="btn btn-large btn-primary pull-right m-l_20" ng-click="formData.skipSslVerification=false;connectHub()" ng-if="!isEditOperation">
                Connect
            </button>
            <button class="btn btn-large btn-primary pull-right" ng-click="formData.skipSslVerification=false;connectHub(false)" ng-if="!isEditOperation">
                Connect and add another
            </button>
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"  ng-click="close()">
                Cancel
            </button>
        </div>
    </script>

    <script type="text/ng-template" id="confirmSuperHubEnabling.html">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
                <i class="bi bi-x"></i>
            </button>
            <h2>Are you sure you want to continue?</h2>
        </div>
        <div class="row modal-body">
            <div class="text-center">
                Enabling this Hub as a Superhub is an irreversible action.
                You will not be able to revert this action.
                We recommend that you only use a freshly installed Hub for this.
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-large btn-primary pull-right" ng-click="enable()">
                Enable
            </button>
            <button class="btn btn-large btn-info pull-left" type="button" class="close" data-dismiss="modal"  ng-click="close()">
                Cancel
            </button>
        </div>
    </script>
</main>
