/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint es5: true */
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for checks
 *
 **/


var alertsServiceClass = Class.extend({
        DASHBOARD_URL: MP_SITE_URL + '/dashboard',
        ALERTSAPI_URL: MP_SITE_URL + '/dashboard/alertsapi',
        EVENTSAPI_URL: MP_SITE_URL + '/eventslogapi',
        SCRIPTSAPI_URL: MP_SITE_URL + '/dashboard/scriptsapi',
        getalerts: function (alertsList) {
            var url, urlParams;
            url = this.ALERTSAPI_URL + '/alerts/';
            urlParams = '';

            // encode parameter as array
            if (alertsList) {
                if (alertsList instanceof Array) {
                    urlParams = alertsList.join(',');
                } else {
                    urlParams = alertsList;
                }

                url += encodeURIComponent(urlParams);
            }

            return this.$http.get(url, {cache: false});
        },
        /**
         * return alert with rule information
         */
        getalertswithrule: function(alertsList) {
            var url, urlParams;
            url = this.ALERTSAPI_URL + '/alertswithrule/';
            urlParams = '';

            // encode parameter as array
            if (alertsList) {
                if (alertsList instanceof Array) {
                    urlParams = alertsList.join(',');
                } else {
                    urlParams = alertsList;
                }

                url += encodeURIComponent(urlParams);
            }

            return this.$http.get(url, {cache: false});
        },

        savealert: function (alertObj) {
            var url = this.ALERTSAPI_URL + '/savealert/';
            //TODO:
            // ask: should we keep previous alert results (hosts count, percentage, fails etc) if we update alert ?
            alertObj['site_url'] = MP_SITE_URL;

            //hack - remove
            if (alertObj['rule']) {
                delete alertObj['rule'];
            }

            if (alertObj.id) {
                url += encodeURIComponent(alertObj.id);
            }

            return this.$http.post(url, alertObj, {cache: false});
        },

        deletealert: function (alertId) {
            var url = this.ALERTSAPI_URL + '/deletealert/' + encodeURIComponent(alertId);
            return this.$http['delete'](url, {cache: false});
        },

        getalertevents: function (alertId, loadLimit) {
            var url = this.EVENTSAPI_URL + '/geteventsforitembyid/' + encodeURIComponent(alertId);
            var data = {};
            data.load_limit = loadLimit;
            return this.$http.post(url, data, {cache: false});
        },

        getalerthosts: function (alertId, loadLimit) {
            var url = this.ALERTSAPI_URL + '/getalerthosts/' + encodeURIComponent(alertId);
            var data = {};
            data.load_limit = loadLimit;
            return this.$http.post(url, data, {cache: false});
        },
        pausealert:function(alertId, time) {
            var url = this.ALERTSAPI_URL + '/pausealert/';
            var data = {};
            data.alertid = alertId;
            data.time    = time;
            return this.$http.post(url, data, {cache: false});
        },
        resumealert:function(alertId) {
            var url = this.ALERTSAPI_URL + '/resumealert/';
            var data = {};
            data.alertid = alertId;
            return this.$http.post(url, data, {cache: false});
        },

        getAlertStatsBySeverity: function (alertsIds) {
            var url = this.ALERTSAPI_URL + '/getalertstatsbyseverity/';
            var data = {};
            data.alertsIds= alertsIds;
            return this.$http.post(url, data, {cache: false});
        },
        getAllScripts: function()
        {
            var url = this.SCRIPTSAPI_URL + '/scripts';
            return this.$http.get(url, {cache: false});
        },
        getNotificationScriptForAlert: function(alert)
        {
            var alertId = alert.id;
            var url = this.SCRIPTSAPI_URL + '/scripts/'+ alertId;
            return this.$http.get(url, {cache: false});
        }
    });

(function () {
    var alertsServiceProvider = Class.extend({
        instance: new alertsServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('alertsServiceModule', [])
        .provider('alertsService', alertsServiceProvider);
}());