<?php

namespace CMDB\v2\Entities;

final class CmdbHostSubEntry
{
    public function __construct(
        public readonly ?int $id = null,
        public readonly string $hostkey,
        public ?int $entry_id = null,
        public readonly string $item_name,
        public readonly string $item_type,
        public readonly mixed $item_value = null,
    ) {
    }

    public function toArray(): array
    {
        return [
            'hostkey' => $this->hostkey,
            'entry_id' => $this->entry_id,
            'item_name' => $this->item_name,
            'item_type' => $this->item_type,
            'item_value' => json_encode($this->item_value)
        ];
    }

    public function setEntryId(int $id): void
    {
        $this->entry_id = $id;
    }
}
