<?php


class Cmdb_model extends Cf_Model
{
    private $endpoint = '/cmdb/v2';

    public function getItems($hostkey, $offset = 0, $limit = 6)
    {
        return json_decode($this->getRestClient()->get("{$this->endpoint}/$hostkey?skip=$offset&limit=$limit"), $associative = true);
    }

    public function getPolicyConfigurationIds($hostkey)
    {
       return json_decode($this->getRestClient()->get("{$this->endpoint}/$hostkey/policy-configuration-ids"), $associative = true);
    }

    public function updateItem($id, $data)
    {
        return $this->getRestClient()->put("{$this->endpoint}/entry/$id", $data);
    }

    public function createItem($hostkey, $data)
    {
       return json_decode($this->getRestClient()->post("{$this->endpoint}/$hostkey", $data), $associative = true);
    }

    public function deleteItem($id)
    {
        return $this->getRestClient()->delete("{$this->endpoint}/entry/$id/");
    }

    public function getItemByName($hostkey, $type, $name)
    {
        return $this->getRestClient()->get("{$this->endpoint}/subentry/$hostkey/$type/$name/");
    }

    public function getJSON($hostkey) {
        return $this->getRestClient()->get(url: "{$this->endpoint}/$hostkey/json", processBody: false);
    }
}
