'use strict';
/*
 * Service to work with http
 *
 **/
var inventoryServiceClass = Class.extend({
    ADV_REPORTS_URL: MP_SITE_URL + '/advancedreports',
    INVENTORY_STATISTIC_URL: MP_SITE_URL + '/dashboard/inventoryWidget/statistic',

    getInventoryStats: function (queryData) {
        var data = $.param(queryData);
        return this.$http({
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.INVENTORY_STATISTIC_URL,
            data: data,
            cache: false
        });
    },

    getInventoryFields: function (data) {
        var url = this.ADV_REPORTS_URL + '/getinventoryfields';
        return this.$http.get(url, {cache: false});
    },
    updateVariablesDictionary: function (fields) {
        var data = $.param({
            fields: fields
        });
        return this.$http({
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: this.ADV_REPORTS_URL + '/updatevariablesdictionary',
            data: data,
            cache: false
        });
    }
});


(function () {
    var inventoryServiceProvider = Class.extend({
        instance: new inventoryServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('inventoryServiceModule', [])
        .provider('inventoryService', inventoryServiceProvider);
}());