<!DOCTYPE html>
<html lang="en" class="<?= getThemeClass() ?>">
    <?php $this->load->view('auth/head.php'); ?>
    <?php include(VIEWPATH . '/includes/custom_styles.php');?>
    <body class="<?= getThemeClass() ?>">
        <div class="login-wrapper">

             <!--[if lte IE 7]><script src="<?php echo get_scriptdir() ?>/ieupgrade/warning.js"></script><script>window.onload=function(){e("<?php echo get_scriptdir() ?>/ieupgrade/")}</script><![endif]-->
                <div id="login">
                    <div class="login-box">
                        <div class="center">
                            <?php if (getCustomLogoFile('logo_on_login')) { ?><img style="max-height: 100px; margin-left: 10px" src="<?= getCustomLogoFile() ?>" /> <?php } ?>
                        </div>
                        <div class="center" style="margin-top: 11px;">
                            <a id="cfe_logo" href="/">
                                <?= '<img width="169" src="'.base_url().'images/CFEngine_enterprise_logo'. (isDarkMode() == true ? '_dark' : '') .'.svg" alt="'.$this->lang->line('nova_logo_link_text').'" />' ?>
                            </a>
                        </div>
                        <div id="login-form-container">
                            <?php echo form_open("login/index", array("class" => "form-horizontal","id"=>"loginform","autocomplete"=>"off")); ?>

                             <div class="margin-top" style="min-height:20px">
                                 <?php

                                if(! ((isset($_SERVER['HTTPS'] )  && $_SERVER['HTTPS'] != 'off')))
                                {
                                     echo '<p class="alert alert-warning"> You are currently using a non-secure connection to the CFEngine Mission Portal. <a id="https-link" href="'. str_replace('http','https',site_url()) .'">Click here</a> to use a secure connection.</p>';
                                }
                                ?>

                                <?php
                                if (isset($message) && is_array($message))
                                {
                                    ?>

                                    <p class="alert alert-error">
                                        <?php echo $message['content'] ?>
                                    </p>

                                <?php } ?>


                                <input type="hidden" id="type_form" name="type_form" value="login"></input>
                            </div>

                            <div class="control-group <?= $twoFa ? 'hide' : ''?>">
                                <label class="control-label" for="<?= htmlspecialchars(strtolower($lbl_identifier)) ?>"><?= htmlspecialchars($lbl_identifier) ?></label>
                                <div class="controls">
                                    <div class="input-append">
                                        <?php echo form_input($identifier); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="control-group <?= $twoFa ? 'hide' : ''?>">
                                <label class="control-label" for="password">Password</label>
                                <div class="controls">
                                    <div>
                                        <?= form_input($password) . $this->load->view('common/show-password-btn.php', [], true) ?>
                                    </div>
                                    <a class="margin-top-small display-block" href="/auth/forgot-password">Forgot your password?</a>
                                </div>
                            </div>  
                            
                            <?php if ($twoFa) { ?>
                            <div class="control-group two-fa margin-top">
                                <label class="control-label margin-bottom-small" for="twoFaCode">Authentication code</label>
                                <div class="controls">
                                    <div>
                                        <?= form_input($twoFa) ?>
                                        <div class="margin-top-small margin-bottom">Open your authentication app on your device to retrieve the code.</div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>

                            <div class="control-group">
                                <div class="controls">
                                    <label title="Stay logged in for one week." class="checkbox inline <?= $twoFa ? 'hide' : ''?>" style="font-size:14px">
                                        <?php echo form_checkbox('remember', '1', FALSE); ?>Remember me
                                    </label>

                                    <?php echo form_input($timezone); ?>
                                    <button type="submit" class="btn btn-large btn-primary pull-right">Log in</button>
                                    <a href="/login/index" type="submit" class="btn btn-large btn-secondary pull-right margin-right-small <?= !$twoFa ? 'hide' : ''?>">Cancel</a>
                                </div>
                            </div>


                            <?php echo form_close(); ?>
                        </div>
                    <?= isset($login_text) ? htmlspecialchars($login_text) : '' ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
            $this->carabiner->display('login');
        ?>
    </body>
</html>
<script type="text/javascript">
    /**
     * Detect the browser time zone and submit it as login info to store in session for date conversions
     *
     */
    var timezone = jstz.determine(); // Now you have an instance of the TimeZone object.
    document.getElementById('timezone').value = timezone.name(); // set the field


    var fileref=document.createElement("link")
    fileref.setAttribute("rel", "stylesheet")
    fileref.setAttribute("type", "text/css")
    fileref.setAttribute("href", "<?php echo get_cssdir(); ?>museo-variants.css");
    document.getElementsByTagName("head")[0].appendChild(fileref);

    //reset the storage value which stops the onboard wizard from appearing more than once per session
    if (!sessionStorage.hasOwnProperty('seen_wizard')){
        sessionStorage.seen_wizard = false;
    }
    if (!sessionStorage.hasOwnProperty('tour_session_initialized')){
        sessionStorage.tour_session_initialized = false;
    }
    localStorage.clear();

</script>

