<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';
class TwoFaApi extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');
        $this->load->model('TwoFaModel');
    }

    public function configure_get()
    {
        $data = $this->TwoFaModel->getConfiguration();
        $data['2faUrl'] = html_entity_decode($data['2faUrl']);
        $this->respond_ok(json_encode($data));
    }

    public function verify_configuration_post()
    {
        $data = json_decode($this->request->body, true);
        $result = $this->TwoFaModel->verifyConfiguration($data['code'] ?? '');
        $this->respond_ok(json_encode($result));
    }  
    
    public function verify_post()
    {
        $code = $this->input->post('code');
        $result = $this->TwoFaModel->verify($code);
        if ($result['valid']) {
            $this->respond_ok($result['message']);
        } else {
            $this->respond_unprocessable_entity($result['message']);
        }
    }
    
    public function disable_post()
    {
        $data = json_decode($this->request->body, true);
        $result = $this->TwoFaModel->disable($data['code'] ?? '');
        $this->respond_ok(json_encode($result));
    }

    public function disable_to_user_post($username)
    {
        $data = json_decode($this->request->body, true);
        $result = $this->TwoFaModel->disableToUser($username, $data['code'] ?? '');
        $this->respond_ok(json_encode($result));
    }

    public function mustUserEnable2Fa_get()
    {
        $result = $this->TwoFaModel->mustUserEnable2Fa($this->username);
        $this->respond_ok(json_encode(['isEnforced' => $result]));
    }

    public function unlock_user_post($username)
    {
        $result = $this->TwoFaModel->unlockUser($username);
        $this->respond_ok(json_encode($result));
    }
}
