<?php

/**
 * Class SlistImplementation
 */
class SlistImplementation implements FormatInventoryFilterInterface
{
    /**
     * @param $value
     * @param $operator
     * @return mixed|string
     */
    public function getValueForWhere($value, $operator, \PDO $pdo)
    {
        switch ($operator) {
            case 'matches':
            case 'not_match':
                $value = $pdo->quote("(,\s|^)$value(,|$)");
                break;
            case 'contains':
            case 'not_contain':
                $value = $pdo->quote("%" . $value . "%");
                break;
            case 'is_reported':
            case 'is_not_reported':
                $value = null;
                break;
        }
        return $value;
    }

}
