'use strict';

var modulesServiceClass = Class.extend({
    MODULES_URL: MP_SITE_URL + '/build_app/build_modules/modules',
    MODULE_URL: MP_SITE_URL + '/build_app/build_modules/module',

    getList: function ($params = {}) {
        return this.$http.get(`${this.MODULES_URL}?${(new URLSearchParams($params)).toString()}` , {cache: false});
    },
    refreshList: function () {
        return this.$http.post(this.MODULES_URL);
    },
    get: function (name, version = null) {
        let url = `${this.MODULE_URL}/${name}`;

        if (version) {
            url += `/${version}`
        }

        return this.$http.get(url , {cache: false});
    },
});

(function () {
    const modulesServiceClassProvider = Class.extend({
        instance: new modulesServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('modulesServiceModule', []).provider('modulesService', modulesServiceClassProvider);
}());
