StartTest(function (t) {
    
    //==================================================================================================================================================================================
    t.diag("Sanity")
    
    var Joose       = require('../../../')
    var Librarian   = require('../lib/Librarian')
    var File        = require('../lib/File')
    
    t.ok(Librarian, 'Librarian is here')

    
    //==================================================================================================================================================================================
    t.diag("Creating library")

    var path            = require('path')
    
    var librarian       = new Librarian({
        root        : path.normalize(path.join(__dirname, '../test_data'))
    })
    
    var file        = librarian.getFile('lib/Backend/Cool.js')

    
    //==================================================================================================================================================================================
    t.diag("Get content of")
    
    var content     = librarian.getContentOf(file)
    
    t.like(content, "isa     : require('../Backend'),", 'Correct content for file')
    

    //==================================================================================================================================================================================
    t.diag("Raw dependencies")
    
    t.isDeeply(file.rawDependencies(), [ 'jojo', 'joose', '../Backend' ], 'Correct raw deps')
    
    
    //==================================================================================================================================================================================
    t.diag("Resolve")
    
    var additionalDeps      = {}
    var resolveJojo         = librarian.resolve('jojo', file, additionalDeps)
    
    t.is(resolveJojo, 'node_modules/jojo/super/cool.js', 'Correctly resolved jojo')
    t.isDeeply(additionalDeps, {
        
        'node_modules/jojo/package.json'        : librarian.getFile('node_modules/jojo/package.json')
        
    }, 'Correctly resolved jojo')
    
    t.is(librarian.resolve('./lib/Backend', '.'),       'lib/Backend.js', 'Correct resolve #1, path normalized')
    t.is(librarian.resolve('./Backend', 'lib'),         'lib/Backend.js', 'Correct resolve #2, path normalized')
    t.is(librarian.resolve('./Cool.js', './lib/Backend'),  'lib/Backend/Cool.js', 'Correct resolve #3, path normalized')
    
    t.is(librarian.resolve('../Backend/Cool', './lib/Backend'),     'lib/Backend/Cool.js', 'Correct resolve #4, path normalized')
    t.is(librarian.resolve('../node_modules/../node_modules/cujo', 'lib'),     'node_modules/cujo/index.js', 'Correct resolve #5, path normalized')
    t.is(librarian.resolve('../node_modules/../node_modules/cujo/./', 'lib/././../lib'),     'node_modules/cujo/index.js', 'Correct resolve #6, path normalized')
    

    //==================================================================================================================================================================================
    t.diag("In depth dependencies")
    
    t.isDeeply(file.getInDepthDependencies(), {
        
        'node_modules/jojo/super/cool.js'       : librarian.getFile('node_modules/jojo/super/cool.js'),
        'node_modules/jojo/package.json'        : librarian.getFile('node_modules/jojo/package.json'),
        'node_modules/joose/index.js'           : librarian.getFile('node_modules/joose/index.js'),
        'lib/Backend.js'                        : librarian.getFile('lib/Backend.js'),
        'node_modules/jobo/index.js'            : librarian.getFile('node_modules/jobo/index.js'),
        'node_modules/cujo/index.js'            : librarian.getFile('node_modules/cujo/index.js')
        
    }, 'Correct dependencies for cool backend found')
    
    t.isDeeply(librarian.getFile('node_modules/joose/index.js').getInDepthDependencies(), {}, 'Correct dependencies for joose found')
    
    t.isDeeply(librarian.getFile('lib/Backend.js').getInDepthDependencies(), {
        
        'node_modules/joose/index.js'           : librarian.getFile('node_modules/joose/index.js'),
        'node_modules/jobo/index.js'            : librarian.getFile('node_modules/jobo/index.js'),
        'node_modules/cujo/index.js'            : librarian.getFile('node_modules/cujo/index.js')
        
    }, 'Correct dependencies for backend found')
    

    

    t.done()
})