// File

var path        = require('path')
var fs          = require('fs')
var detective   = require('detective')
var Joose       = require('../../../joose-all')

module.exports = Joose.Class({
    
    has     : {
        // name should be already resolved relative librarian's root
        name                : { required : true },
        librarian           : { required : true },
        
        rawDependencies     : {
            is      : 'rwc',
            lazy    : '_buildRawDependencies'
        },
        
        inDepthDependencies : null
    },
    
    
    methods : {
        
        _buildRawDependencies : function () {
            return detective(this.librarian.getContentOf(this.name), 'utf8')
        },
        
        
        getInDepthDependencies : function (context) {
            if (this.inDepthDependencies) return this.inDepthDependencies
            
            var me          = this
            var name        = this.name
            var noContext   = !context
            
            context         = context || {}
            context[ name ] = true
            
            var dependencies    = {}
            var librarian       = this.librarian
            
            Joose.A.each(this.rawDependencies(), function (require) {
                
                var resolved                = librarian.resolve(require, me, dependencies)
                
                // do not recurse into visited nodes
                if (context[ resolved ]) return
                
                var dependencyFile          = dependencies[ resolved ]    = librarian.getFile(resolved)
                
                Joose.O.each(dependencyFile.getInDepthDependencies(context), function (file, name) {
                    
                    if (dependencies[ name ] && dependencies[ name ] != file) throw new Error("Inconsistency")
                    
                    dependencies[ name ] = file
                })
            })
            
            // remove dependency from itself if any
            delete dependencies[ name ]
            
            // we only collect the full deps when we started as a root-level call (w/o context)  
            if (noContext) this.inDepthDependencies = dependencies
            
            return dependencies
        }
    }

})