<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class Cmdb extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('cmdb_model');
    }

    public function items_get($hostkey)
    {
        try {
            $list = $this->cmdb_model->getItem($hostkey);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get cmdb list. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_post($hostkey, $type, $name)
    {
        try {
            $data = json_decode($_REQUEST['data'], true);
            $list = $this->cmdb_model->createItem($hostkey, $type, $name, $data);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to update cmdb. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_put($hostkey, $type, $name)
    {
        try {
            preg_match('/data=(.*)$/', $this->_put_args, $matches);
            $data = json_decode(urldecode($matches[1]), true);
            $list = $this->cmdb_model->updateItem($hostkey, $type, $name, $data);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to update cmdb. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_get($hostkey, $type, $name)
    {
        try {
            $list = $this->cmdb_model->getItemByName($hostkey, $type, $name);
            $this->respond(200, json_encode($list));
            return;
        } catch (HttpClient_NotFound $exception) {
            $this->respond(404);
        } catch (Exception $exception) {
            log_message('error', 'Unable to get cmdb item. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_delete($hostkey, $type, $name)
    {
        try {
            $list = $this->cmdb_model->deleteItem($hostkey, $type, $name);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to delete cmdb item. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }
}
