<!DOCTYPE html>
<html lang="en">
<?php $this->load->view('auth/head.php'); ?>
<body>
<div class="login-wrapper">
    <div id="login">
        <div class="login-box relative center">
            <div class="absoluteCentered" style="width: 90%">
                <div style="padding: 0 39px 5px 39px">
                    <h2>Password reset</h2>
                    <p class="margin-bottom">
                        Enter the username you sign in to Mission Portal with to receive a reset password link by email.
                    </p>
                </div>
                <?php if (isset($message)) { ?>
                    <div class="alert <?= htmlspecialchars($message['type']) ?>"><?= htmlspecialchars($message['content']) ?></div>
                <?php } ?>

                <?php echo form_open('auth/forgot-password', array('class' => 'form-horizontal', 'id' => 'forgot-password')); ?>


                <div class="control-group">
                    <label class="control-label" for="username">Username:</label>
                    <div class="controls">
                        <input id="username" type="text" name="username" class="input-xlarge"
                               value="<?= htmlspecialchars($username) ?>"/>
                    </div>
                </div>
                <div class="control-group margin-top">
                    <div class="controls">
                        <button type="submit" id="submit"
                                class="btn btn-large btn-primary float-right margin-left-small"
                        >
                            Send reset password link
                        </button>
                        <a href="<?php echo site_url('login'); ?>" class="btn btn-large btnCancel float-right"
                           type="button">Cancel</a>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <?php $this->carabiner->display('login'); ?>
    <script>
        document.querySelector('#forgot-password').addEventListener('submit', () => {
            document.querySelector('#submit').setAttribute('disabled', 'disabled');
            common.globalSpinner.show();
        });
    </script>
</div>
</body>
</html>