<div class="settingsPage">

    <div class="left-column">
        <?php include('settingsSideBar.php'); ?>
    </div>

    <div class="right-column">

        <div class="pageTitle">
            <h1>
                <span>Custom notification scripts</span>
            </h1>
        </div>

        <div class="pullTop">

            <?php
            if (($this->session->flashdata('message')) || (!empty($message) && is_array($message)))
            {
                $flashMessage = $this->session->flashdata('message') ? $this->session->flashdata('message') : $message;
                $content = $flashMessage['content'];
                $content_class = $flashMessage['type'];
                ?>

                <div class="alert <?= htmlspecialchars($content_class) ?>
                     ">
                    <button class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                    <?= nl2br(htmlspecialchars($content)); ?>
                </div>
            <?php } ?>
        </div>

        <div class="scriptLists">

        <?php if(count($scripts)>0) { ?>

            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>Script Name</th>
                    <th>Description</th>
                    <th>File name</th>
                    <th class="actions right">Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($scripts as $script) { ?>
                    <tr>
                        <td><?= htmlspecialchars($script->getName()) ?></td>
                        <td><?= htmlspecialchars($script->getDescription()) ?></td>
                        <td><?= htmlspecialchars($script->getScriptFileName()) ?></td>
                        <td class="right actions"><a href="notification-scripts/edit/<?= htmlspecialchars($script->getId()) ?>" class="icon icon-pencil"></a><a onclick="return confirm('Are you sure you want to delete the script?')" href="notification_scripts/delete/<?= htmlspecialchars($script->getId()) ?>" class="icon icon-trash"></a></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>

            <?php }
            else { ?>
                <div class="alert alert-warning">There are no notification scripts to show. <a href="notification-scripts/add">Add a new script</a></div>
            <?php } ?>

            <div class="buttons">
                <div class="pull-right">
                    <a class="btn btn-large" href="notification-scripts/add">Add a script</a>
                </div>
            </div>
        </div>

    </div>
</div>