if ($('input:checked[name="mode"]').val() == 'internal') {
    $('.ldap-form').hide();
    $('#ldapsettings').hide();
}

$('input[name="encryption"]').change(function () {
    if (this.value == 'ssl') {
        $('#port').val(636);
    } else {
        $('#port').val(389);
    }
});



$('input[name="mode"]').change(function () {
    if (this.value == 'ldap') {
        $('.ldap-form').show();
        $('#ldapsettings').show();

    } else {
        $('.ldap-form').hide();
        $('#ldapsettings').hide();
    }
    saveAuthMethod(this.value);
});

function saveAuthMethod(mode) {
    $.post('/settings/saveAuthenticationMethod', {
        mode: mode
    }).done(function (data) {
        data = JSON.parse(data);
        if (data.status == true) {
            notify.success("Authentication method successfully saved");
        } else {
            notify.error("Something went wrong. Please see the log file.");
        }
    });
}

if (typeof isLdapConfigured !== 'undefined' && isLdapConfigured) {
    const form = document.getElementById('mpsettings');
    const logoutUsersLabel = document.getElementById('logoutUsersLabel');
    const notVisibleClass = 'notVisible';
    let initialFormValues = {};

    new FormData(form).forEach((value, key) => {
        initialFormValues[key] = value;
    });
    
    const isLdapFormChanged = () => {
        let formChanged = false;

        new FormData(form).forEach((value, key) => {
            if (initialFormValues[key] !== value) {
                formChanged = true;
            }
        });

        return formChanged;
    }

    if (logoutUsersLabel) {
        form.addEventListener('input', () => logoutUsersLabel.classList.toggle(notVisibleClass, !isLdapFormChanged()));
    }
}
