<?php

namespace FR\V1_0\Controllers;

use AuditLogActions;
use AuditLogObjectTypes;
use AuditLogFields;
use AuditLogService;
use FR\V1_0\Entities\RemoteHub\RemoteHub;
use FR\V1_0\Models\SetupHubModel;

/**
 * @uri /fr/v1.0/hub-state
 * @uri /fr/hub-state
 */
class HubState extends \CfProtectedResource
{
    private $setupHubModel;

    public function __construct($parameters)
    {
        parent::__construct($parameters);

        $cfSettings = \CfSettings::getInstance()->getConnection();
        $this->setupHubModel = new SetupHubModel($cfSettings, $this->username);
    }

    /**
     * @param $request
     *
     * @rbacName Change hub target state
     * @rbacGroup Federation report API
     * @rbacAlias hubState.post
     *
     * @return \Response
     * @throws \Exception
     */
    public function put($request)
    {
        $response = new \Response($request);
        $data = \Utils::getValidJsonData($request->data);

        if (!isset($data->target_state) || empty($data->target_state) || !in_array($data->target_state, RemoteHub::$allowedStates)) {
            $message = 'Wrong `target_state` value. Allowed values: ' . implode(', ', RemoteHub::$allowedStates);
            syslog(LOG_DEBUG, $message);
            $response->code = \Response::BADREQUEST;
            $response->body = $message;
        } else {
            $this->setupHubModel->setTargetState($data->target_state);
            $response->code = \Response::ACCEPTED;
            AuditLogService::register([
                AuditLogFields::ACTOR => $this->username,
                AuditLogFields::OBJECT_TYPE => AuditLogObjectTypes::FEDERATED_REPORTING,
                AuditLogFields::ACTION => AuditLogActions::UPDATE,
                AuditLogFields::DETAILS => ["Changed hub's federated reporting state from {$this->setupHubModel->getTargetState()} to {$data->target_state}."]
            ]);
        }

        return $response;
    }

    /**
     * @param $request
     *
     *
     * @return \Response
     * @throws \Exception
     */
    public function get($request)
    {
        $response = new \Response($request);
        $response->body = json_decode(['target_state' => $this->setupHubModel->getTargetState()]);
        $response->code = \Response::ACCEPTED;
        return $response;
    }

}
