<?php

class FavoriteHostGroupsModel
{
    private $dbConnection;
    private $table = 'favorite_groups';

    public function __construct()
    {
        $this->dbConnection = CfSettings::getInstance()->getConnection();
    }

    public function add($id, $username)
    {
        $stmt = $this->dbConnection->prepare(
            "INSERT INTO {$this->table} (username, group_id) VALUES (?, ?) ON CONFLICT DO NOTHING"
        );
        return $stmt->execute([$username, $id]);
    }

    public function remove($id, $username)
    {
        $stmt = $this->dbConnection->prepare(
            "DELETE FROM {$this->table} WHERE username = ? AND group_id = ?"
        );
        return $stmt->execute([$username, $id]);
    }
}
