function hostsummary(redhosts,yellowhosts,greenhosts,total){
   var ua = navigator.userAgent,
      iStuff = ua.match(/iPhone/i) || ua.match(/iPad/i),
      typeOfCanvas = typeof HTMLCanvasElement,
      nativeCanvasSupport = (typeOfCanvas == 'object' || typeOfCanvas == 'function'),
      textSupport = nativeCanvasSupport
        && (typeof document.createElement('canvas').getContext('2d').fillText == 'function');
  //I'm setting this based on the fact that ExCanvas provides text support for IE
  //and that as of today iPhone/iPad current text support is lame
  var labelType = (!nativeCanvasSupport || (textSupport && !iStuff))? 'Native' : 'HTML';
  var nativeTextSupport = labelType == 'Native';
  var useGradients = nativeCanvasSupport;
  var animate = !(iStuff || !nativeCanvasSupport);
  var json = [
      //"root" node is invisible
      {
        "id": "node0",
        "name": "",
        "data": {
          "$type": "none"
        },
        "adjacencies": [
            {
              "nodeTo": "node1",
              "data": {
                '$type': 'none'
              }
            }, {
              "nodeTo": "node2",
              "data": {
                '$type': 'none'
              }
            }, {
              "nodeTo": "node3",
              "data": {
                '$type': 'none'
              }
            }
        ]
      }, {
        "id": "node1",
        "name": "Red Hosts",
        "data": {
          "$angularWidth": (360/total)*redhosts,
          "$color": "#dd3333",
          "$height": 70,
          "numbers":redhosts,
          "type":"red"
        },
        "adjacencies": [
            {
              "nodeTo": "node2",
              "data": {
                "$color": "#ddaacc",
                "$lineWidth": 4
              }
            }, {
              "nodeTo": "node3",
              "data": {
                "$color": "#ccffdd",
                "$lineWidth": 4
              }
            }
        ]
      }, {
        "id": "node2",
        "name": "Yellow Hosts",
        "data": {
          "$angularWidth": (360/total)*yellowhosts,
          "$color": "#FFFF00",
          "$height": 73,
          "numbers":yellowhosts,
          "type":"yellow"
        },
        "adjacencies": [
            "node1", "node3"
        ]
      }, {
        "id": "node3",
        "name": "Green hosts",
        "data": {
          "$angularWidth": (360/total)*greenhosts,
          "$color": "#bf0",
          "$height": 75,
          "numbers":greenhosts,
          "type":"green"
        },
        "adjacencies": [
            "node1", "node2"
        ]
      }
  ];
  //end
}