import React from 'react';
import {
  Box,
  Typography
} from '@mui/material';

import { CmdbItem } from '../../../store/cmdbSlice/thunks';
import { getFirstEntryName, getFirstEntryValue } from '../../../utils';

interface InventoryViewProps {
  item: CmdbItem;
  onValueClick?: () => void;
  classes?: Record<string, string>;
}

const InventoryView: React.FC<InventoryViewProps> = ({ 
  item, 
  onValueClick = () => {}, 
  classes = {} 
}) => {
  return (
    <>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Name:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.name}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Policy variable:
        </Typography>
        <Box className={`${classes.value} ${classes.nameValue}`}>
          {getFirstEntryName(item)}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Value:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {getFirstEntryValue(item)}
        </Box>
      </Box>
      <Box className={classes.container}>
        <Typography className={classes.key}>
          Description:
        </Typography>
        <Box onClick={onValueClick} className={classes.value}>
          {item.description}
        </Box>
      </Box>
    </>
  );
};

export default InventoryView;
