<?php

/**
 * Class Compliance_score
 */
class Compliance_score extends Cf_Model
{
    /**
     * @param $reportIds
     * @param $userName
     * @return array
     */
    public function getScore(array $reportIds , $userName) : array
    {
       return $this->db
           ->from('compliance_score')
           ->where_in('report_id', $reportIds)
           ->where('username', $userName)
           ->get()
           ->result_array();
    }

    /**
     * @param CF_ComplianceScore $data
     */
    public function setScore(CF_ComplianceScore $data)
    {
        $sql = $this->db->set($data->toArray())->get_compiled_insert('compliance_score');
        $sql .= ' ON CONFLICT (report_id, username) DO UPDATE SET score = EXCLUDED.score, fail_checks = EXCLUDED.fail_checks, update_ts = now()';
        $this->db->query($sql);
    }
}
