var DCA = {};


DCA.RuleTypes_dropDown = [
    {"value": "policy", "label": "Policy"},
    {"value": "inventory", "label": "Inventory"},
    {"value": "softwareupdate", "label": "Software updates"},
    {"value": "fileChanged", "label": "File changed"},
    {"value": "custom", "label": "Custom SQL"}
];

DCA.RuleTypes_dropDown_with_deselect = [
    ...DCA.RuleTypes_dropDown,
    {"value": "cancel", "label": "Deselect"}
];

DCA.RuleCategories_dropDown = [
    {"value": "Applications", "label": "Applications"},
    {"value": "Cloud", "label": "Cloud"},
    {"value": "Containers", "label": "Containers"},
    {"value": "Hardware", "label": "Hardware"},
    {"value": "Infrastructure", "label": "Infrastructure"},
    {"value": "Operating System", "label": "Operating System"},
    {"value": "Security", "label": "Security"},
    {"value": "Other", "label": "Other"},
];

DCA.RuleSeverity = [
    {"value": "high", "label": "High", "order": 3},
    {"value": "medium", "label": "Medium", "order": 2},
    {"value": "low", "label": "Low", "order": 1}
];

DCA.Policy_TypeFilter = [
    {"value": "bundlename", "label": "Bundle"},
    {"value": "promisees", "label": "Promisee"},
    {"value": "promiser", "label": "Promiser"}
];

DCA.Policy_Promiseoutcome = [
    {"value": "KEPT", "label": "Kept"},
    {"value": "NOTKEPT", "label": "Not kept"},
    {"value": "REPAIRED", "label": "Repaired"}
];

DCA.softwareFilterConditions = [
    'matches',
    'is'
];

DCA.fileChangedFilterConditions = [
    'matches',
    'is'
];

DCA.Severity_dropDown = [
    {"value": "low", "label": "Low"},
    {"value": "medium", "label": "Medium"},
    {"value": "high", "label": "High"}
];

DCA.WidgetTypes_dropDown = [
    {"value": "alerts", "label": "Alerts"}
];

DCA.Pause_dropDown = [
    {"value": -1, "label": "Indefinitely"},
    {"value": 1800, "label": "30 mins"},
    {"value": 3600, "label": "1 hour"},
    {"value": 21600, "label": "6 hours"},
    {"value": 43200, "label": "12 hours"},
    {"value": 86400, "label": "1 day"},
    {"value": 604800, "label": "1 week"}
];

DCA.Page_size = [
    5,
    10,
    20,
    50,
    100
];


DCA.CheckReminder_dropDown = [
    {"value": 60, "label": "Every min"},
    {"value": 300, "label": "Every 5 mins"},
    {"value": 600, "label": "Every 10 mins"},
    {"value": 900, "label": "Every 15 mins"},
    {"value": 1800, "label": "Every 30 mins"},
    {"value": 3600, "label": "Every 1 hour"},
    {"value": 6200, "label": "Every 2 hours"},
    {"value": 18000, "label": "Every 5 hours"},
    {"value": 86400, "label": "Every 24 hours"},
    {"value": 604800, "label": "Every week"},
    {"value": 1209600, "label": "Every 2 weeks"},
    {"value": 1814400, "label": "Every 3 weeks"},
    {"value": 2419200, "label": "Every 4 weeks"}
];

DCA.Default_widgets = [
    {"name": "Changes", "type": "changes", "alert": {}},
    {
        "name": "Software updates",
        "type": "alerts",
        "alert": {"ruleid": 1, "severity": "low", "name": "Software updates available"}
    },
    {
        "name": "Policy compliance", "type": "alerts", "alert": [
            {"ruleid": 2, "severity": "medium", "name": "Entire CFEngine policy"},
            {"ruleid": 3, "severity": "medium", "name": "Policy Deployment"},
        ]
    },
    {"name": "System health", "type": "alerts", "alert": {"ruleid": 12, "severity": "high", "name": "Low disk space"}},
    {"name": "Newly bootstrapped hosts", "type": "hostCount", "alert": {}},
    {"name": "Decommissioned hosts", "type": "decommissionedHosts", "alert": {}},
    {"name": "OS", "type": "inventory", "alert": {}, "payload": '{"inventoryAttribute":"OS","chartType":"pie"}'},
    {"name": "File changes", "type": "fileChanges", "alert": {}},
    {"name": "Not kept, not repaired count", "type": "notKeptNeverRepaired", "alert": {}},
]

window.DCA = DCA;
