import { makeStyles } from 'tss-react/mui';

export const useValidateStyles = makeStyles()(theme => ({
  container: {
    width: '100%',
    height: '100vh',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: theme.palette.grey[50]
  },
  input: {
    height: 'auto'
  },
  loginBox: {
    width: '100%',
    maxWidth: '600px'
  },
  subtitle: {
    fontWeight: 500,
    marginTop: 1
  },
  codeBlock: {
    display: 'flex',
    alignItems: 'center',
    gap: 1,
    bgcolor: theme.palette.grey[50],
    padding: 2,
    borderRadius: 1
  },
  codeText: {
    fontFamily: '"Red Hat Mono", monospace',
    flex: 1
  },
  copyIcon: {
    cursor: 'pointer'
  }
}));

export const useCompleteStyles = makeStyles()(theme => ({
  container: {
    width: '100%',
    height: '100vh',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: theme.palette.grey[50]
  },
  loginBox: {
    width: '100%',
    maxWidth: '600px'
  },
  titleIcon: {
    marginRight: theme.spacing(1),
    color: theme.palette.green[500],
    fontSize: 24
  },
  subtitle: {
    fontSize: 16,
    fontWeight: 500
  },
  rememberMeLabel: {
    fontSize: 14,
    paddingTop: '0 !important',
    margin: 0
  }
}));
