dashboardApp.directive('hostCountWidget', ['hostCountWidgetHelper', '$q', function (hostCountWidgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/host_count_widget',
        restrict: 'A',
        scope: {
            widget: '=',
            currentUser: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',

        },
        link: function (scope, element) {
            scope.fromToData = {};
            scope.selectedGroup = 'Day';
            scope.dateRange = hostCountWidgetHelper.initDateRange();
            scope.groups = [
                'Day',
                'Week',
                'Month',
                'Year'
            ];

            scope.refresh = function () {
                return element.attr('refresh');
            }

            scope.$watch(scope.refresh, function (){
                scope.chartList = hostCountWidgetHelper.getChartConfig()
            })

            scope.$watch('dateRange', function () {
                scope.fromToData = {from: scope.dateRange.startDate, to: scope.dateRange.endDate};
            });

            scope.$watchCollection('[fromToData, selectedGroup, refresh]', function (newValues) {
                hostCountWidgetHelper.getHostCountStats(newValues[0], newValues[1]).then(
                    function (result) {
                        hostCountWidgetHelper.setChartData(result.data.data);
                        scope.widget.changeStats = result.data.data;
                        scope.chartList = hostCountWidgetHelper.chartConfig;
                    }
                );
            });
        }
    };

}]);
