<?php

/**
 * Class DeletedHostsReportSqlBuilder
 */
class DeletedHostsReportSqlBuilder extends BaseHealthDiagnosticSqlBuilder
{
    /**
     * @var string
     */
    protected $sql = 'SELECT hostkey FROM deleted_hosts_report';

    /**
     * @var string
     */
    protected $nonOverlappedSql;

    /**
     * @var string
     */
    protected $reportSql = 'SELECT h.Hostkey as key, * FROM deleted_hosts_report h';

    /**
     * @return string
     */
    public function getSql(): string
    {
        return $this->sql;
    }

    /**
     * Return report sql
     *
     * @return string
     */
    public function getReportSql(): string
    {
        return $this->reportSql;
    }

}
