<div class="project-create">
    <div class="margin-top top">
        <h1 ng-if="project.id">Edit project</h1>
        <h1 ng-if="!project.id">Add new project</h1>
        <div ng-if="project.id">
            <button ng-click="delete(project.id)" class="btn btn-danger-outline">Delete project</button>
        </div>
    </div>
    <hr/>
    <div class="subtitle">
        Enter your Git repository information to set up a remote repository for your project.
    </div>
    <?= $this->load->view('/partials/errors') ?>
    <div class="required margin-top">
        *required
    </div>
    <form name="projectForm" autocomplete="off">
        <div class="flex">
            <div>
                <label for="repositoryUrl">Repository URL <span class="required">*</span></label>
                <input ng-pattern="repositoryUrlPattern" ng-required="true" name="repositoryUrl" id="repositoryUrl"
                       ng-model="project.repositoryUrl" build-url-auth-validator />
                <div class="error" ng-show="projectForm.repositoryUrl.$invalid && projectForm.repositoryUrl.$dirty">
                    <span ng-show="projectForm.repositoryUrl.$error.required">Repository URL is required.</span>
                    <span ng-show="projectForm.repositoryUrl.$error.pattern">
                        Malformed repository URL. Expected a valid git URL. Supported protocols: git, ssh, http(s)
                    </span>
                    <span ng-show="projectForm.repositoryUrl.$error.httpUrlSshAuth">
                        HTTP(S) URL together with SSH key authentication type cannot be used
                    </span>
                    <span ng-show="projectForm.repositoryUrl.$error.sshUrlPasswordAuth">
                        SSH URL together with username/password authentication type cannot be used
                    </span>
                </div>

            </div>
            <div>
                <label for="branch">Branch <span class="required">*</span></label>
                <input ng-required="true" name="branch" id="branch" ng-model="project.branch"/>
                <div class="error" ng-show="projectForm.branch.$invalid && projectForm.branch.$dirty">
                    <span ng-show="projectForm.branch.$error.required" ng-model="project.branch">Branch is required.</span>
                </div>
            </div>
        </div>
        <div>
            <div class="radio_group">
                <span>Authentication type:</span>
                <div>
                    <input type="radio" id="password_authentication" name="authenticationType"
                           ng-model="project.authenticationType" value="password" build-url-auth-validator />
                    <label for="password_authentication">Username/password</label>
                </div>
                <div>
                    <input type="radio" id="private_key_authentication" name="authenticationType"
                           ng-model="project.authenticationType" value="private_key" build-url-auth-validator />
                    <label for="private_key_authentication">SSH key</label>
                </div>
            </div>
            <div ng-if="project.authenticationType=='password'" class="flex">
                <div>
                    <label for="username">Username <span class="required">*</span></label>
                    <input ng-required="project.authenticationType=='password'" name="username" id="username"
                           ng-model="project.username"/>
                    <div class="error" ng-show="projectForm.username.$invalid && projectForm.username.$dirty">
                        <span ng-show="projectForm.username.$error.required">Username is required.</span>
                    </div>
                </div>
                <div class="relative">
                    <label for="password">Password/token <span class="required">*</span></label>
                    <input ng-required="project.authenticationType=='password'" type="password" name="password" id="password"
                           ng-model="project.password" placeholder="{{ passwordPlaceholder }}"/>
                    <?php $this->load->view('common/show-password-btn.php'); ?>
                    <div class="error" ng-show="projectForm.password.$invalid && projectForm.password.$dirty">
                        <span ng-show="projectForm.password.$error.required">Password/token is required.</span>
                    </div>
                </div>
            </div>
            <div ng-if="project.authenticationType=='private_key'">
                <div ng-if="!publicKey">
                    <div class="flex flex--align_center private-key-area">
                        <div>
                            <label for="private_key">Private key <span class="required">*</span></label>
                            <textarea ng-required="project.authenticationType=='private_key'"
                                      name="sshPrivateKey" id="sshPrivateKey"
                                      placeholder="{{ sshKeyPlaceholder }}"
                                      ng-model="project.sshPrivateKey"></textarea>
                        </div>
                        <div class="or">
                            Or
                        </div>
                        <div class="controls">
                            <label for="file-selector">Upload a key file:</label>
                            <label class="btn btn-default" for="file-selector">
                                <input id="file-selector" onchange="keyUploaded(this)" name="file" type="file" style="display:none" class="ng-isolate-scope" />
                                Choose a file
                            </label>
                        </div>
                    </div>
                    <div class="error" ng-show="projectForm.sshPrivateKey.$invalid && projectForm.sshPrivateKey.$dirty">
                        <span ng-show="projectForm.sshPrivateKey.$error.required">Private key is required.</span>
                    </div>
                    <div><a class="blue500 generate-ssh" ng-click="generateSshKey()" href="javascript:void(0)">Generate</a> a public/private key pair </div>
                </div>
                <div ng-if="publicKey">
                    <label for="private_key">Public key <span class="required">*</span></label>
                    <div>Copy this key into the setting of your git provider, for example, Github.</div>
                    <textarea name="publicKey" id="publicKey"
                              placeholder="{{ sshKeyPlaceholder }}"
                              ng-model="publicKey"></textarea>
                    <div class="error" ng-show="projectForm.sshPrivateKey.$invalid && projectForm.sshPrivateKey.$dirty">
                        <span ng-show="projectForm.sshPrivateKey.$error.required">Private key is required.</span>
                    </div>
                    <div><a ng-click="deleteSshKey(project.sshKeyId)" href="javascript:void(0)" class="red delete-key">Delete</a> generated key pair</div>
                </div>
            </div>
        </div>
        <hr/>
        <div>
            <div class="flex flex--align_start">
                <input style="width: 15px" type="checkbox" id="classic_policy_set" name="classicPolicySet"
                       ng-model="project.classicPolicySet" value="1"/>
                <label for="classic_policy_set">Classic policy set (not cfbs):</label>
            </div>
        </div>
        <div style="max-width: 500px"
             ng-show="(loadedProject.repositoryUrl != project.repositoryUrl || loadedProject.branch != project.branch) && projectId"
             class="alert alert-error pull-right"
        >
            <span>
                By changing the repository url or branch you will initialize a new project and the current one will be
                removed from the file system and not pushed changes will be lost.
            </span>
        </div>
        <div class="buttons">
            <div>
                <label for="name">Project name</label>
                <input name="name" id="name" ng-model="project.name"/>
            </div>
            <div>
                <a ng-hide="projectId" class="btn btn-transparent margin-right-xs" ng-click="save(true)">
                    Set up later
                </a>
                <a ng-show="projectId" class="btn btn-transparent margin-right-xs" ng-href="/build/project/{{ projectId }}">
                    Cancel
                </a>
                <a ng-show="!projectId" class="btn btn-transparent margin-right-xs" ng-href="/build/">
                    Cancel
                </a>
                <button ng-hide="projectId" ng-disabled="projectForm.$invalid || saveBtnDisabled" class="btn btn-primary" ng-click="save()">
                    Save
                </button>
                <button ng-show="projectId" ng-disabled="projectForm.$invalid || updateBtnDisabled" class="btn btn-primary" ng-click="update()">
                    Update
                </button>
            </div>
        </div>
    </form>
</div>

<script type="text/ng-template" id="copySsh.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
            <i class="bi bi-x"></i>
        </button>
        <h2>SSH Key</h2>
    </div>
    <div class="modal-body">
        <strong>Public key</strong>
        <span>Copy this key into the setting of your git provider, for example, Github.</span>
        <div>
            <textarea width="100%">{{ publicKey }}</textarea>
        </div>
        <button class="btn btn-info" onclick="common.copyTextToClipBoard(this.parentElement.querySelector('textarea').value.trim())">
            Copy to clipboard
        </button>
    </div>
    <div class="modal-footer">
        <button class="btn btn-large btn-info pull-right" type="button" class="close" data-dismiss="modal"
                 ng-click="close()">
            Close
        </button>
    </div>
</script>

<script type="text/ng-template" id="removeSshKey.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
            <i class="bi bi-x"></i>
        </button>
        <h2>Delete SSH key pair</h2>
    </div>
    <div class="modal-body">
        Are you sure you want to delete the generated SSH key pair?  This process
        cannot be undone.
    </div>
    <div class="modal-footer">
        <button class="btn btn-large btn-danger pull-right" type="button"
                 ng-click="delete()">
            Delete
        </button>
        <button class="btn btn-large btn-info pull-right" type="button" class="close" data-dismiss="modal"
                 ng-click="close()">
            Cancel
        </button>
    </div>
</script>

<script>
    const keyUploaded = function (element) {
        const reader = new FileReader();
        reader.readAsText(element.files[0], "UTF-8");
        const sshPrivateKeyTextarea = document.getElementById('sshPrivateKey');
        reader.onload = e => {
            sshPrivateKeyTextarea.value = e.target.result;
            sshPrivateKeyTextarea.dispatchEvent(new Event('change'));
            element.value = null;
        }
        reader.onerror =  () => notify.error('Error reading file.');
    }
</script>

<script type="text/ng-template" id="removeProject.html">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="close()">
            <i class="bi bi-x"></i>
        </button>
        <h2>Delete project</h2>
    </div>
    <div class="modal-body">
        Are you sure you want to delete "{{ name }}" project? This process cannot be undone.
        <div ng-if="projectSynchronizedWithVcs" class="margin-top">
            <label class="flex flex--align_center">
                <input type="checkbox" ng-model="data.stopDeploying" value="1" /> Stop deploying policy from this repository, by resetting VCS settings
            </label>
        </div>
    </div>
    <div class="modal-footer">
        <button class="btn btn-large btn-danger pull-right" type="button"
                 ng-click="delete()">
            Delete
        </button>
        <button class="btn btn-large btn-info pull-right" type="button" class="close" data-dismiss="modal"
                 ng-click="close()">
            Cancel
        </button>
    </div>
</script>
