/*
 * CFEngine Mission Common Utility functions
 */
var common = (function(){


                var _spinnerCounter = 0;
                var showSpinner =  function() {
                    _spinnerCounter++;
                    $("#globalSpinner").show();
                    document.body.dispatchEvent(new CustomEvent('spinner', {detail: {isOn: true}}));
                };
                var hideSpinner= function(flag) {
                    _spinnerCounter--;
                    if (_spinnerCounter <= 0) {
                        _spinnerCounter = 0;
                        $("#globalSpinner").hide();
                        document.body.dispatchEvent(new CustomEvent('spinner', {detail: {isOn: false}}));
                    }
                };

    return {

        colours: {
            red: '#d1292',
            yellow: '#f8851b',
            green: '#99cb8e',
            blue: '#476e8c',
            black: '#000000',
            white: '#ffffff'
        },

        globalSpinner: {
                show:showSpinner,
                hide:hideSpinner
        },

        time: {
            // e.g. Jan 25th, 2008
            formatDate: function(javascriptTimestamp) {
                var date = new Date(javascriptTimestamp);
                return date.format('M dS Y');
            },

            // e.g. 22:42
            formatTimeOfDay: function(javascriptTimestamp) {
                var date = new Date(javascriptTimestamp);

                var hours = date.getHours() + "";
                var mins = date.getMinutes() + "";

                if (hours.length < 2) {
                    hours = "0" + hours;
                }

                if (mins.length < 2) {
                    mins = "0" + mins;
                }

                return hours + ":" + mins;
            },
            formatGMTOffset:function(javascriptTimestamp) {
                var date = new Date(javascriptTimestamp);
                return date.format('P');
            },

            format: function(javascriptTimestamp, format = 'Y-m-d H:i:s', tzIncluded = true) {
                const timeZone = timezone.getTimeZoneFromStorage();
                // if unix timestamp then apply timezone offset
                if (Number.isInteger(javascriptTimestamp) && timeZone !== null) {
                    // add profile and current browser's time offsets in milliseconds to unix timestamps
                    // otherwise, the resulting time will have an additional offset when we create date from unix time `new Date(javascriptTimestamp).
                    // getTimezoneOffset() is positive if the local timezone is behind UTC and negative if it is ahead
                    // that's why we add instead of subtract.
                    javascriptTimestamp += ((timeZone.minutesOffset + (new Date()).getTimezoneOffset()) * 60 * 1000);
                }
                let convertDate = new Date(javascriptTimestamp);
                let dateString = convertDate.format(format);
                if (tzIncluded == true && timeZone !== null) {
                    // add time zone offset to date time string
                    dateString += timeZone.offset;
                }
                return dateString;
            },

            calculateNumberOfDays: function(milliseconds) {
                var oneDay = 24*60*60*1000; // hours*minutes*seconds*milliseconds
                return Math.round(Math.abs(milliseconds)/oneDay);
            }
        },

       /**
        *  Utitlity function to handle common ajax error senarios
        *
        *  $opts[statusCode] = ajax error code
        *  $opts[targetDiv] =  jquery object to show the error
        *  $opts[msg] =  optional message to show
        *  $opts[errorStatusMap] = object to override default msg and add new status and message
        *
        */
        showAjaxError: function($opts) {

            var statusCode = $opts.statusCode || null;
            var $errorDiv  = $opts.targetDiv || null;

            function showError($msg,$div) {
                var $errorDiv = $div || null;
                if ($errorDiv) {
                    var $span = $('<div style="margin-top:10px;">').addClass('alert alert-error').html($msg);
                    $errorDiv.empty().append($span).show();
                }
            }


            var errorStatusMap = {
                401: 'Access denied while trying to fetch data.',
                403: 'Unauthorized access.',
                404: 'Cannot fetch data as supplied url is not found.',
                500: 'Invalid server response when trying to fetch data.',
                0:   'Cannot contact the server.',
                204: 'No data available.'
            };

            $.extend(errorStatusMap, $opts.errorStatusMap);

            if (errorStatusMap[statusCode]) {
                showError(errorStatusMap[statusCode],$errorDiv);
            } else {
                showError("Cannot fetch data due to unknown error",$errorDiv);
            }
        },

        arrayWithValue: function(value, length) {
            var arr = new Array(length);
            for (var i = 0; i < arr.length; i++) {
                arr[i] = value;
            }
            return arr;
        },

        canonify: function(expression) {
            return expression.replace(/[^A-Za-z0-9]+/g, '_');
        },

        isValidClassExpression: function(expression) {
            try {
                new RegExp(expression);
                return true;
            } catch (e) {
                return false;
            }
        },

        randomUUID: function() {
            var S4 = function() {
                return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
            };
            return (S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4());
        },

        unixTimeToJavascriptTime: function(unixTime) {
            return unixTime * 1000;
        },

        javascriptTimeToUnixTime: function(javascriptTime) {
            return javascriptTime / 1000;
        },

        getLocalTimeStringFromUTC:function(utcTimeStamp){
            var d=new Date(0);
            d.setUTCSeconds(utcTimeStamp);

            var month=common.getDoubleDigits(d.getMonth()+1);
            var date=common.getDoubleDigits(d.getDate());
            var hour=common.getDoubleDigits(d.getHours());
            var minutes=common.getDoubleDigits(d.getMinutes());
            var dateString=d.getFullYear()+'-'+month+'-'+date+' '+hour+':'+minutes;
            return dateString;
        },

        getDoubleDigits:function(number){
            if(number < 10){
                return '0'+number;
            }
            return number;
        },

        generateRandomString: function (length) {
            let text = "";
            let dictionary = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()}|?>:";

            for (let i = 0; i < length; i++)
            {
                text += dictionary.charAt(Math.floor(Math.random() * dictionary.length));
            }

            return text;
        },

        copyTextToClipBoard: function (text) {
            navigator.clipboard.writeText(text).then(
                function () {
                    notify.success('Copied.');
                }, function (err) {
                    notify.error('Could not copy text to clipboard: ' + err);
                });
        },

        showTooltip: function (event, text) {
            this.hideTooltip();
            $('<div class="ui-tooltip">' + text + '</div>').css({
                position: 'absolute',
                top: event.pageY + 5,
                left: event.pageX + 10
            }).appendTo('body');
        },
        hideTooltip: function () {
            $('.ui-tooltip').remove();
        }
    };
})();


var mediator = (function(){
    var subscribe = function(channel, fn){
        if (!mediator.channels[channel]) mediator.channels[channel] = [];
        mediator.channels[channel].push({
            context: this,
            callback: fn
        });
        return this;
    },

    publish = function(channel){
        if (!mediator.channels[channel]) return false;
        var args = Array.prototype.slice.call(arguments, 1);
        for (var i = 0, l = mediator.channels[channel].length; i < l; i++) {
            var subscription = mediator.channels[channel][i];
            subscription.callback.apply(subscription.context, args);
        }
        return this;
    };

    return {
        channels: {},
        publish: publish,
        subscribe: subscribe,
        installTo: function(obj){
            obj.subscribe = subscribe;
            obj.publish = publish;
        }
    };

}());

var stringToArray=function(commaSeparatedString){
    var resultfromExplode=commaSeparatedString.split(',');

    if(resultfromExplode.length==1 && resultfromExplode[0]=="" ){
        return [];
    }else{
        return  resultfromExplode;
    }
};

String.prototype.hashCode = function(){
    var hash = 0;
    if (this.length == 0) return hash;
    for (var i = 0; i < this.length; i++) {
        var charc = this.charCodeAt(i);
        hash = ((hash<<5)-hash)+charc;
        hash = hash & hash; // Convert to 32bit integer
    }
    return hash;
}

String.prototype.capitalizeFirstLetter = function(){
    return this.charAt(0).toUpperCase() + this.slice(1);
}

String.prototype.htmlSpecialChars =  function(){
    return this
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;');
}

const sortObjectAlphabetically = object =>
    Object.keys(object)
        .sort((a, b) => a.toLowerCase().localeCompare(b.toLowerCase()))
        .reduce(
            (obj, key) => {
                obj[key] = object[key];
                return obj;
            },
            {}
        );


Array.prototype.uniqueOnly = function () {
    if (Array.isArray(this)) {
        return [...new Set(this)];
    }
}
Object.defineProperty(Array.prototype, "uniqueOnly", { enumerable: false });

const htmlSpecialCharsDecode = function (obj) {
    if (typeof obj === 'string') {
        obj = obj.replace(/&amp;/g, '&')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>')
            .replace(/&#039;/g, '\'')
            .replace(/&quot;/g, '"');
    }

    if (obj instanceof Array) {
        obj = obj.map(value => htmlSpecialCharsDecode(value))
    }

    return obj;
}

// Export node module.
if ( typeof module !== 'undefined' && module.hasOwnProperty('exports') )
{
    module.exports = common;
}

let unAuthorizedHandlerTriggered = false;
const unAuthorizedHandler = function () {
    if (!unAuthorizedHandlerTriggered) {
        bootbox.alert('Your session has expired. You will be redirected to the Login page.');
        unAuthorizedHandlerTriggered = true;
        window.location.href = '/login/index';
    }
}

$.ajaxSetup({
    statusCode: {
        401: function() {
            unAuthorizedHandler();
        }
    }
});

let widgetFullScreen = function (element) {
    let widgetWrapper = element.closest('li');
    let widget = element.closest('div.widget');

    let changeHandler = () => {
        document.fullscreenElement ?
            widget.classList.add('full-screen-widget') :
            widget.classList.remove('full-screen-widget');
    };

    widgetWrapper.addEventListener('fullscreenchange', changeHandler, false);

    document.fullscreenElement ?
        document.exitFullscreen() :
        widgetWrapper.requestFullscreen();
};

const openInventoryWidgetReport = function (element) {
    let widget = $(element).attr('widget');

    if (widget == undefined) {
        return;
    }

    widget = JSON.parse(widget);
    if (widget.payload != undefined && widget.payload.inventoryAttribute != undefined) {
        const inventoryWidget = new BaseInventoryWidget(widget.payload);
        inventoryWidget.clickAction();
    }
}

const darkModeToggle = function (checkbox) {
    const className = 'dark';
    const el = $('html, body');
    const checked = checkbox.checked;
    if (checked) {
        el.addClass(className);
    } else {
        el.removeClass(className);
    }
    $('body').trigger('DARK_THEME_CHANGED', checked);
    $.post('/darkMode/update', {
        enabled: checked == true ? 1 : 0
    }).fail((error) => {
        notify.error(error.responseText);
    });
    const changeLogo = () => {
        let logoSrc = $('#cfe_logo img').attr('src');
        // change logo img src when theme is changed
        logoSrc = checked ? logoSrc.replace('.svg', '_dark.svg') : logoSrc.replace('_dark.svg', '.svg');
        $('#cfe_logo img').attr('src', logoSrc)
    }
    changeLogo();

    const event = new CustomEvent('themeChange', { detail: { darkMode: checked } });
    window.dispatchEvent(event);
}

const isDarkModeEnabled = () => $('body.dark').length > 0;

const widgetColors = {
    mainColor: () => isDarkModeEnabled() ? '#7A8FF5' :'#274BA7',
    pieColors: () => isDarkModeEnabled() ?
        ['#7A8FF5', '#C1C9E2', '#FEDB3E', '#F5821F', '#F89B56', '#F2CDB5','#E5E5E5'] :
        ['#274BA7', '#646EB7', '#FEDB3E', '#F5821F', '#F89B56', '#F2CDB5','#E5E5E5'],
    complianceColors: () => {
        return {
            'pie': (isDarkModeEnabled() ? ['#45B26B', '#EC5242'] : ['#079649', '#D74936']),
            'subtitle': (isDarkModeEnabled() ? 'rgba(255, 255, 255, 0.6)' : '#515253'),
        }
    },
    pieNavigationColors: () => {
        return {
            activeColor: (isDarkModeEnabled() ? '#CCC' : '#3E576F'),
            textColor: (isDarkModeEnabled() ? '#CCC' :  '#333'),
        }
    }
};

const unbindBeforeUnload = () => window.onbeforeunload = null;

const removeTooltipOnButtonClick = () => document.querySelectorAll('button').forEach(btn => btn.onclick = () => {
    const tooltip = document.querySelector('div[role="tooltip"]');
    if (tooltip) {
        tooltip.remove();
    }
});

/**
 * Show page leaving confirmation dialog if form with `confirm-before-leave` class is changed and not saved
 */
const processPageBeforeLeave = function () {
    const formElement = document.querySelector('.confirm-before-leave');
    // do not show dialog if form does not exist or hidden
    if (formElement == null || $('.confirm-before-leave').is(':hidden')) {
        unbindBeforeUnload();
    }
    const serializeForm = formElement => new URLSearchParams(new FormData(formElement)).toString();
    const formChangedCallback = () => {
        window.onbeforeunload = (serializeForm(formElement) != formElement.getAttribute('initialState')) ?
            () => "Changes that you made may not be saved." :
            null;
    }
    if (formElement !== null) {
        // set initialState to compare on form change
        formElement.setAttribute('initialState', serializeForm(formElement));
        formElement.addEventListener('change', formChangedCallback);
        formElement.addEventListener('click', formChangedCallback);
        formElement.addEventListener('keyup', formChangedCallback);

        // reset when form submitted
        formElement.addEventListener('submit', () => {
            unbindBeforeUnload();
        });
    }
}
document.addEventListener('DOMContentLoaded', function () {
    processPageBeforeLeave();
    removeTooltipOnButtonClick();
});

const modalThreshold = (function () {
    const millisecondsThreshold = 60 * 60 * 1000; // 1 hour
    const key = 'lastTimeModalSeen';

    return {
        canBeShown: () => {
            return (
                localStorage.getItem(key) === null || ((parseInt(localStorage.getItem(key)) + millisecondsThreshold) < Date.now())
            )
        },
        setShownTime: () => localStorage.setItem(key, Date.now().toString())
    };
})();


function isIpAddressInSubnet(ipAddress, subnet) {
    const [subnetIP, prefixSize] = subnet.split('/');
    const { ipHigh, ipLow } = IPSubnetCalculator.calculateSubnetMask(subnetIP, prefixSize);
    const ipInt = IPSubnetCalculator.toDecimal(ipAddress);
    return ipHigh >= ipInt && ipInt >= ipLow;
}

window.common = common;
window.mediator = mediator;
window.stringToArray = stringToArray;
window.sortObjectAlphabetically = sortObjectAlphabetically;
window.isIpAddressInSubnet = isIpAddressInSubnet;
window.processPageBeforeLeave = processPageBeforeLeave;
window.removeTooltipOnButtonClick = removeTooltipOnButtonClick;
window.modalThreshold = modalThreshold;
window.unbindBeforeUnload = unbindBeforeUnload;
window.htmlSpecialCharsDecode = htmlSpecialCharsDecode;
window.widgetColors = widgetColors;
window.isDarkModeEnabled = isDarkModeEnabled;
window.darkModeToggle = darkModeToggle;
window.widgetFullScreen = widgetFullScreen;
window.openInventoryWidgetReport = openInventoryWidgetReport;
