import React from 'react';
import {
  Box,
  TextField
} from '@mui/material';

interface StringFormProps {
  onChange: (value: string) => void;
  errors: Record<string, string>;
  value?: string;
}

interface StringValueViewProps {
  value: string;
}

const StringForm: React.FC<StringFormProps> = ({ 
  onChange, 
  errors, 
  value = '' 
}) => {
  return (
    <Box sx={{ flexGrow: 1 }}>
      <TextField
        fullWidth
        variant="outlined"
        size="small"
        placeholder="Value"
        value={value}
        onChange={(e) => onChange(e.target.value)}
        error={!!errors.item_value}
        helperText={errors.item_value}
      />
    </Box>
  );
};

export const ValueView: React.FC<StringValueViewProps> = ({ value }) => {
  return <>{value}</>;
};

export default StringForm;
