<div class="graphunit"><?php echo urldecode($units); ?></div>
<div id="placeholder-magview_<?= htmlspecialchars($observable) ?>" class="modal-vital-graph"></div>

<div class="modal-vital-legend">
    <h5>Legends</h5>
    <ul>
        <li><span style="display:inline-block;width:20px;color:rgb(255, 153, 0);font-size: 15px; font-weight: bold;text-align: center;">&mdash;</span> Last measured value</li>
        <li><span style="display:inline-block;width:20px;color:rgb(0, 204, 0);font-size: 15px; font-weight: bold;text-align: center;">&mdash;</span> Average measured value</li>
        <li><span style="display:inline-block;width:20px;color:rgb(204, 204, 204);font-size: 15px; font-weight: bolder;text-align: center;">&mdash;</span> Standard deviations from average </li>
    </ul>
</div>

<script language="javascript" type="text/javascript">
    //<![CDATA[
    (function(){
        var magnifiedViewdata = <?php echo ($graphdata); ?>;
        var lineSeries1 = <?php echo ($graphdatalineseries1); ?>;
        var lineSeries2 = <?php echo ($graphdatalineseries2); ?>;

        var deviationAboveSeries = [];
        var deviationBelowSeries = [];
        var lengthData = magnifiedViewdata.length;

        for (var i = 0; i<lengthData; i++ ) {

            deviationAboveSeries.push([magnifiedViewdata[i][0],magnifiedViewdata[i][2] + magnifiedViewdata[i][3] ]);
            deviationBelowSeries.push([magnifiedViewdata[i][0],magnifiedViewdata[i][2] - magnifiedViewdata[i][3]]);
        }


        var options = { series: {
                magnifiedView: {
                    active: true,
                    lastUpdated : "<?php echo $graphLastUpdated; ?>"
                }
            }
            ,grid:   { hoverable: true, clickable: true,axisMargin: 15,labelMargin: 15},
            yaxis: {
                min: <?php echo $graphdatamin; ?>,
                max: <?php echo $graphdatamax; ?>
            },

            xaxis: {
                max:48,

                tickSize:6,

                tickFormatter: function (val, axis) {

                    var subtract = (4-(val/12))*60*60;

                    var actualDate = parseInt(options.series.magnifiedView.lastUpdated,10);
                    var displayDate = actualDate -subtract;
                    var d = new Date();
                    d.setTime( displayDate * 1000 );
                    var minutes = (d.getMinutes() < 10) ? '0'+d.getMinutes() : d.getMinutes();
                    return d.getHours() + ' : ' +minutes;


                }
            }
        };
        var plot = $.plot($("#placeholder-magview_<?= htmlspecialchars($observable) ?>"),
        [
            { label:"",data:lineSeries1,id:"last-measured",lines: {show: true, lineWidth: 1,fill:false},color:"rgb(255, 153, 0)"},
            { label:"",data:lineSeries2,id:'average',lines: {show: true, lineWidth: 1,fill:false},color:"rgb(0, 204, 0)"},
            { label:"",data:deviationAboveSeries,fillBetween:'average',lines: {show: true, lineWidth: 0,fill:true},color:"rgb(204, 204, 204)"},
            { label:"",data:deviationBelowSeries,fillBetween:'average',lines: {show: true, lineWidth: 0,fill:true},color:"rgb(204, 204, 204)"}
        ]
        ,options);


        $("#placeholder-magview_<?= htmlspecialchars($observable) ?>").on("plothover", function (event, pos, item) {
            if (item) {
                if (previousPoint != item.datapoint) {
                    previousPoint = item.datapoint;

                    $("#tooltip").remove();
                    var x = item.datapoint[0].toFixed(2),
                    y = item.datapoint[1].toFixed(2);

                    showTooltip(item.pageX, item.pageY, y);
                }
            }
            else {
                $("#tooltip").remove();
                previousPoint = null;
            }
        });
        function showTooltip(x, y, contents) {


            $('<div id="tooltip">' + contents + '</div>').css( {
                position: 'absolute',
                display: 'none',
                top: y + 5,
                left: x + 5,
                border: '1px solid #fdd',
                padding: '10px',
                color: '#000',
                'background-color': '#fee',
                opacity: 0.80,
                zIndex:10000
            }).appendTo("body").fadeIn(200);
        }

    })();
    //]]>
</script>
