import React from 'react';
import { Box, IconButton } from '@mui/material';
import { isDarkMode } from '@northern.tech/store/utils';
import { Close as CloseIcon, OpenInFull as OpenInFullIcon } from '@mui/icons-material';
import { makeStyles } from 'tss-react/mui';
import AiAgentHeader from './AiAgentHeader';

const useStyles = makeStyles()(theme => ({
  minimizedChatWrapper: {
    position: "fixed",
    bottom: 70,
    right: 20,
    boxShadow: "0 4px 16px 0 rgba(0, 0, 0, 0.24), 0 0 2px 0 rgba(0, 0, 0, 0.24)",
    padding: "8px 22px",
    width: 235,
    borderRadius: 4,
    zIndex: 99,
    backgroundColor: isDarkMode(theme.palette.mode) ? theme.palette.darkBackground[500] :  theme.palette.background.default
  }
}));

interface MinimizedChatProps {
  onClose: () => void;
  onOpen: () => void;
}

const MinimizedChat: React.FC<MinimizedChatProps> = ({ onClose, onOpen }) => {
  const { classes } = useStyles();

  return (
    <Box className={classes.minimizedChatWrapper}>
      <Box
        sx={{
          display: 'flex',
          alignItems: 'center',
          justifyContent: 'space-between'
        }}
      >
        <AiAgentHeader fontSize={16} />
        <Box sx={{ opacity: .6 }}>
          <IconButton onClick={onOpen}>
            <OpenInFullIcon />
          </IconButton>
          <IconButton aria-label="close" onClick={onClose}>
            <CloseIcon />
          </IconButton>
        </Box>
      </Box>
    </Box>
  );
};

export default MinimizedChat;
