<?php


/**
 * Class DbConnection
 */
class DbConnection
{
    /**
     * @var null
     */
    private static $instance = null;
    /**
     * @var PDO
     */
    private $conn;

    /**
     * @var string
     */
    private $host = OAUTH_DATABASE_HOST;
    /**
     * @var string
     */
    private $user = OAUTH_DATABASE_USER;
    /**
     * @var string
     */
    private $pass = OAUTH_DATABASE_PASS;
    /**
     * @var string
     */
    private $name = CFDB_DATABASE_NAME;
    /**
     * @var int
     */
    private $port = OAUTH_DATABASE_PORT;

    /**
     * DbConnection constructor.
     */
    private function __construct()
    {
        $this->conn = new PDO("pgsql:host={$this->host}; dbname={$this->name};port={$this->port}", $this->user, $this->pass);
    }

    /**
     * @return DbConnection|null
     */
    public static function getInstance()
    {
        if (!self::$instance) {
            self::$instance = new DbConnection();
        }

        return self::$instance;
    }

    /**
     * @return PDO
     */
    public function getConnection()
    {
        return $this->conn;
    }
}
