<div class="settingsPage">
    <div class="left-column">
        <?php include(APPPATH . 'views/appsetting/settingsSideBar.php'); ?>
    </div>
    <div class="right-column margin-bottom">
        <div class="pageTitle">
            <h1>
                <span>Role based access control</span>
            </h1>
        </div>
        <ol class="breadcrumb">
            <li>RBAC</li>
            <li><a href="<?= site_url('settings/rbac') ?>">Select role</a></li>
            <li class="active"><?= htmlspecialchars($role) ?></li>
        </ol>

        <form method="post" class="margin-bottom confirm-before-leave">
            <?php foreach ($permissions as $appName => $appData) { ?>
                <h3><?= htmlspecialchars($appName) ?></h3>
                <?php foreach ($appData as $groupName => $groupData) { ?>
                    <table class="table table-bordered w-auto inline-table margin-right permission-table">
                        <thead>
                        <tr>
                            <th>
                                <span><input type="checkbox" class="select-all-permissions"> </span>
                            </th>
                            <th><?= htmlspecialchars($groupName) ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($groupData as $permission) { ?>
                            <tr>
                                <td><span><input type="checkbox" <?php if (in_array($permission['alias'], array_column($rolePermissions, 'alias'))) { ?>checked="checked"<?php } ?> name="permissions[]" value="<?= htmlspecialchars($permission['alias']) ?>"> </span></td>
                                <td><?= $permission['name'] ?>
                                    <span class="help-block"><?= $permission['description'] ?></span>
                                </td>
                            </tr>
                        <?php } ?>

                        </tbody>
                    </table>
                <?php } ?>
            <?php } ?>
            <hr />
            <div class="pull-right margin-bottom">
                <button type="submit" class="btn btn-primary btn-large pull-left">Save</button>
            </div>
        </form>
    </div>

    <script>
        $('.select-all-permissions').change(function () {
            if($(this).is(':checked')) {
                $(this).closest('table').find('input[type="checkbox"]').prop('checked', 'checked');
            } else {
                $(this).closest('table').find('input[type="checkbox"]').prop( "checked", false );
            }
        })

        // if count of checkboxes is equal to checked checkboxes count then set top level as checked, otherwise unchecked
        const selectAllPermissions = (table, item) => item.checked = table.querySelectorAll('td input[type="checkbox"]').length == table.querySelectorAll('td input[type="checkbox"]:checked').length;
        // process top level checkboxes on rbac items click
        document.querySelectorAll('input[name="permissions[]"]').forEach(item => item.addEventListener('click', e => {
            const table = e.target.closest('table');
            selectAllPermissions(table, table.querySelector('input.select-all-permissions'));
        }));
        // process top level checkboxes after page loading
        document.querySelectorAll('input.select-all-permissions').forEach(item => selectAllPermissions(item.closest('table'), item))
    </script>
