import React from 'react';
import { Button, type ButtonProps } from '@mui/material';
import Dialog from './Dialog';

type DialogSize = 'xs' | 'sm' | 'md' | 'lg' | 'xl';

type ConfirmColor = ButtonProps['color'];

interface ConfirmationDialogProps {
  open: boolean;
  onClose: () => void;
  onConfirm: () => void;
  title?: string;
  message?: string;
  confirmText?: string;
  confirmColor?: ConfirmColor;
  cancelText?: string;
  size?: DialogSize;
}

const ConfirmationDialog: React.FC<ConfirmationDialogProps> = ({
  open,
  onClose,
  onConfirm,
  title = "",
  message = "",
  confirmText = "Confirm",
  confirmColor = "secondary",
  cancelText = "Cancel",
  size = "sm"
}) => {
  const handleConfirm = () => {
    onConfirm();
    onClose();
  };

  return (
    <Dialog
      open={open}
      fullWidth
      size={size}
      onClose={onClose}
      title={title}
      actionButtons={
        <>
          <Button
            onClick={onClose}
            variant="outlined"
            color="inherit"
            sx={{ mr: 1 }}
          >
            {cancelText}
          </Button>
          <Button
            onClick={handleConfirm}
            variant="contained"
            color={confirmColor}
            autoFocus
          >
            {confirmText}
          </Button>
        </>
      }
    >
      {message}
    </Dialog>
  );
};

export default ConfirmationDialog;
