<?php

class UsersExporter extends BaseDataExporter
{
    private $usersToSkip = ["'admin'", "'CFE_ROBOT'"];

    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function getData(): array
    {
        $data = [];

        if ($this->exportOnlyUserItems == true) {
            $data['cfmp'] = $this->db->get_where("users", ['username' => $this->username])->result_array();
            $data['cfsettings'] = $this->settingsDb->get_where("users", ['username' => $this->username])->result_array();
        } else {
            $data['cfmp'] = $this->db->where_not_in('username',  implode(",", $this->usersToSkip))->get("users")->result_array();
            $data['cfsettings'] = $this->settingsDb->where_not_in('username',  implode(",", $this->usersToSkip))->get("users")->result_array();
        }

        return ['info' => sizeof($data['cfsettings']), 'data' => json_encode($data)];
    }
}
